/*******************************************************************************
 *  Copyright (c) 2010 Association for Decentralized Information Management in
 *  Industry THTH ry.
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License v1.0
 *  which accompanies this distribution, and is available at
 *  http://www.eclipse.org/legal/epl-v10.html
 *
 *  Contributors:
 *      VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.databoard.tests;

import java.util.Arrays;

import org.simantics.databoard.Bindings;
import org.simantics.databoard.Datatypes;
import org.simantics.databoard.annotations.Length;
import org.simantics.databoard.annotations.Optional;
import org.simantics.databoard.annotations.Range;
import org.simantics.databoard.annotations.Unit;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.parser.repository.DataValueRepository;
import org.simantics.databoard.serialization.Serializer;
import org.simantics.databoard.type.Datatype;

public class TestAsciiSerialization {

	public static class RGB {
		
		public RGB() {}
		public RGB(String colorName, int r, int g, int b)
		{
			this.name = colorName;
			this.r = r;
			this.g = g;
			this.b = b;
		}
		
		@Unit("red")
		public int r;
		public int g;
		public int b;
		public String name;
		public int[] data;
		
		@Override
		public String toString() {
			return name+"={r="+r+", g="+g+", b="+b+"}";
		}
		
	}	
	public static class Image {
		@Length({"320", "240"})
		public RGB[][] pixels;
	}
	
//	@Recursive
	public class TestClass {
		public TestClass() {}
		
//		@Max("5")
//		@Min("0")
		
		@Optional Integer X;
		String Y;
		
		@Length("5") @Range("[0..100]") int[] a;
		
//		
//		float[][][] b;
//		
//		TestArray[] c;
//		
//		@Unit("m")
//		double length;
//		
//		public static void main(String[] args) throws Exception {
//			System.out.println(DataTypes.getDataType(TestArray.class));
//					
//		}
	}
	
	public static class VectorSeries {
		public VectorSeries() {}
		@Optional Vector v1;
		@Optional Vector v2;
		@Optional Vector v3;		
	}

	public static class Vector { int x, y, z; }	
	
	public static void main(String[] args) throws Exception {
		
        DataValueRepository vr = new DataValueRepository(); 
		Binding datatypeBinding = Bindings.getBindingUnchecked( Datatype.class );
		
		Datatype vectorType = Datatypes.getDatatypeUnchecked(Vector.class);
		String string = datatypeBinding.printValueDefinition(vectorType, true);
		Datatype vectorType2 = (Datatype) datatypeBinding.parseValueDefinition(string);
		if (!vectorType.equals(vectorType2)) System.err.println("datatype mismatch");
		
		VectorSeries x = new VectorSeries();
		x.v1 = new Vector();
		x.v2 = new Vector();
//		x.v3 = new Vector();
		Bindings.getBinding(VectorSeries.class).printValue(x, System.out, vr, true);
		System.out.println("\n");

		
		Datatype dataType = Datatypes.getDatatype(TestClass.class);
		Datatype testClassDataType = Datatypes.getDatatype(TestClass.class);
		
		Binding dataTypeBinding = Bindings.getBinding(Datatype.class);
		Serializer dataTypeSerializer = dataTypeBinding.serializer();  
				
		byte[] dada;
		
//		dada = dataTypeSerializer.serialize(testClassDataType);						
//		System.out.println(Arrays.toString(dada));

		System.out.println("\n");
		
		
		System.out.println(Datatypes.getDatatype(TestClass.class));
		
		dataTypeBinding.printValue(Datatypes.getDatatype(int[].class), System.out, vr, false);
		System.out.println("\n");
		
		dataTypeBinding.printValue(Datatypes.getDatatype(TestClass.class), System.out, vr, false);
		System.out.println("\n");
		
		dataTypeBinding.printValue(Datatypes.getDatatype(int.class), System.out, vr, false);
		System.out.println("\n");
		
		
		Bindings.getBinding(String.class).printValue("Abu\nDabi\"\\\\\"", System.out, vr, false);
		System.out.println("\n");

		Bindings.getBinding(int[].class).printValue(new int[] {1,2,3,4,5}, System.out, vr, false);
		System.out.println("\n");

//		new BinaryEncoder( new byte[100] ).write(DataTypes.getBinding(int[].class), new int[] {1,2,3,4,5});

		dataTypeBinding.printValue(Datatypes.getDatatype(VectorSeries.class), System.out, vr, false);
		System.out.println("\n");
		
		int[] array = (int[]) Bindings.getBinding(int[].class).parseValueDefinition("[1, 2, 3, 4, 5]");
		System.out.println(Arrays.toString(array));
		System.out.println("\n");
		
		Integer i = (Integer) Bindings.getBinding(Integer.class).parseValueDefinition("5");
		System.out.println(i);
		System.out.println("\n");
		
		Datatype dt = (Datatype) Bindings.getBinding(Datatype.class).parseValueDefinition("RecordType(False \"Vector Series\" [OptionalType(IntegerType(Nothing Nothing)) \"X\", StringType(Nothing Nothing Nothing) \"Y\", ArrayType(IntegerType(Nothing Nothing) 5 5) \"a\"])");
		
		dataTypeBinding.printValue(dt, System.out, vr, false);
		System.out.println("\n");

		dataTypeBinding.printValue(Datatypes.getDatatype(Image.class), System.out, vr, false);		
		System.out.println("\n");

		String str = (String) Bindings.getBinding(String.class).parseValueDefinition("\"Abu\nDabi\\\"\\\\\"\"");
		System.out.println(str);
		System.out.println("\n");

		
	}
	
}

