/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.simulation.project;

import java.util.concurrent.atomic.AtomicReference;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.Metadata;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.VirtualGraph;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.CommentMetadata;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Write;
import org.simantics.db.service.VirtualGraphSupport;
import org.simantics.layer0.Layer0;
import org.simantics.simulation.experiment.ExperimentState;
import org.simantics.simulation.experiment.IExperiment;
import org.simantics.simulation.experiment.IExperimentListener;
import org.simantics.simulation.ontology.SimulationResource;
import org.simantics.simulation.project.IExperimentActivationListener;
import org.simantics.utils.datastructures.Callback;
import org.simantics.utils.ui.ErrorLogger;

public class ExperimentRuns {
    public static void createRun(Session session, Resource experimentResource, IExperiment experiment, IExperimentActivationListener listener, Callback<Resource> successCallback) {
        VirtualGraphSupport support = (VirtualGraphSupport)session.getService(VirtualGraphSupport.class);
        ExperimentRuns.createRun(session, support.getWorkspacePersistent("experiments"), experimentResource, experiment, listener, successCallback);
    }

    public static void createRun(Session session, VirtualGraph graph, Resource experimentResource, IExperiment experiment, IExperimentActivationListener listener, Callback<Resource> successCallback) {
        ExperimentRuns.createRun(session, graph, experimentResource, experiment, "http://www.simantics.org/Simulation-1.1/Run", listener, successCallback);
    }

    public static void createRun(final Session session, VirtualGraph vg, final Resource experimentResource, final IExperiment experiment, final String experimentRunTypeURI, final IExperimentActivationListener listener, final Callback<Resource> successCallback) {
        final AtomicReference _run = new AtomicReference();
        session.asyncRequest((Write)new WriteRequest(vg){

            public void perform(WriteGraph graph) throws DatabaseException {
                Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                final SimulationResource SIMU = SimulationResource.getInstance((ReadGraph)graph);
                final Resource run = graph.newResource();
                String label = NameUtils.findFreshLabel((ReadGraph)graph, (String)"Experiment", (Resource)experimentResource);
                graph.claim(run, L0.InstanceOf, null, graph.getResource(experimentRunTypeURI));
                graph.addLiteral(run, L0.HasName, L0.NameOf, L0.String, (Object)experiment.getIdentifier(), (Binding)Bindings.STRING);
                graph.addLiteral(run, L0.HasLabel, L0.HasLabel_Inverse, L0.String, (Object)label, (Binding)Bindings.STRING);
                graph.addLiteral(run, SIMU.HasActivationTime, SIMU.HasActivationTime_Inverse, L0.Long, (Object)System.currentTimeMillis(), (Binding)Bindings.LONG);
                graph.claim(experimentResource, L0.ConsistsOf, L0.PartOf, run);
                VirtualGraph runtime = (VirtualGraph)graph.getService(VirtualGraph.class);
                graph.syncRequest((Write)new WriteRequest(runtime){

                    public void perform(WriteGraph graph) throws DatabaseException {
                        graph.claim(run, SIMU.IsActive, run);
                    }
                });
                _run.set(run);
            }
        }, (Callback)new Callback<DatabaseException>(){

            public void run(DatabaseException e) {
                if (e != null) {
                    if (listener != null) {
                        listener.onFailure(e);
                    } else {
                        ErrorLogger.defaultLogError((Throwable)e);
                    }
                } else {
                    ExperimentRuns.attachStateListener(session, experiment, (Resource)_run.get());
                    if (successCallback != null) {
                        successCallback.run((Object)((Resource)_run.get()));
                    }
                    if (listener != null) {
                        listener.onExperimentActivated(experiment);
                    }
                }
            }
        });
    }

    private static void attachStateListener(final Session session, IExperiment experiment, final Resource run) {
        experiment.addListener(new IExperimentListener(){

            @Override
            public void stateChanged(ExperimentState state) {
                if (state == ExperimentState.DISPOSED) {
                    VirtualGraph runtime = (VirtualGraph)session.getService(VirtualGraph.class);
                    session.asyncRequest((Write)new WriteRequest(runtime){

                        public void perform(WriteGraph graph) throws DatabaseException {
                            SimulationResource SIMU = SimulationResource.getInstance((ReadGraph)graph);
                            graph.denyStatement(run, SIMU.IsActive, run);
                            CommentMetadata cm = (CommentMetadata)graph.getMetadata(CommentMetadata.class);
                            graph.addMetadata((Metadata)cm.add("Attaching state listener to track isActive for run"));
                        }
                    }, (Callback)new Callback<DatabaseException>(){

                        public void run(DatabaseException e) {
                            if (e != null) {
                                ErrorLogger.defaultLogError((Throwable)e);
                            }
                        }
                    });
                }
            }
        });
    }
}

