/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.simulation.experiment;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.progress.IProgressConstants2;
import org.simantics.DatabaseJob;
import org.simantics.Simantics;
import org.simantics.project.IProject;
import org.simantics.simulation.experiment.IDynamicExperiment;
import org.simantics.simulation.experiment.IExperiment;
import org.simantics.simulation.project.IExperimentManager;

public final class ExperimentUtil {
    public static void step(double duration) {
        IExperimentManager manager = (IExperimentManager)Simantics.getProject().getHint(IExperimentManager.KEY_EXPERIMENT_MANAGER);
        IExperiment experiment = manager.getActiveExperiment();
        if (experiment instanceof IDynamicExperiment) {
            ((IDynamicExperiment)experiment).simulateDuration(duration);
        }
    }

    public static void simulate(boolean enabled) {
        IExperimentManager manager = (IExperimentManager)Simantics.getProject().getHint(IExperimentManager.KEY_EXPERIMENT_MANAGER);
        IExperiment experiment = manager.getActiveExperiment();
        if (experiment instanceof IDynamicExperiment) {
            ((IDynamicExperiment)experiment).simulate(enabled);
        }
    }

    public static void shutdownActiveExperiment(IProject project) {
        ExperimentUtil.shutdownActiveExperiment(project, null);
    }

    public static void shutdownActiveExperiment(IProject project, IProgressMonitor monitor) {
        IExperimentManager manager = (IExperimentManager)project.getHint(IExperimentManager.KEY_EXPERIMENT_MANAGER);
        IExperiment experiment = manager.getActiveExperiment();
        if (experiment != null) {
            experiment.shutdown(monitor);
        }
    }

    public static void scheduleShutdownActiveExperiment(IProject project) {
        IExperimentManager manager = (IExperimentManager)project.getHint(IExperimentManager.KEY_EXPERIMENT_MANAGER);
        final IExperiment experiment = manager.getActiveExperiment();
        if (experiment != null) {
            DatabaseJob job = new DatabaseJob("Shutting down experiment"){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        experiment.shutdown(monitor);
                        IStatus iStatus = Status.OK_STATUS;
                        return iStatus;
                    }
                    finally {
                        monitor.done();
                    }
                }
            };
            job.setProperty(IProgressConstants2.SHOW_IN_TASKBAR_ICON_PROPERTY, (Object)Boolean.TRUE);
            job.setUser(true);
            job.schedule();
        }
    }
}

