/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.simulation.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import org.simantics.databoard.Datatypes;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.NumberBinding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.type.Datatype;
import org.simantics.databoard.util.Bean;
import org.simantics.simulation.data.AbstractDatasource;
import org.simantics.simulation.data.VariableHandle;

public class PseudoSolver
extends AbstractDatasource {
    public static String SINE = "Sine";
    public static String RAMP = "Ramp";
    public static String RANDOM = "Random";
    public static List<String> KEYS;
    Thread thread;
    long startTime;
    double time;
    Random random = new Random();
    int cycle = 0;

    static {
        ArrayList<String> keys = new ArrayList<String>();
        keys.add(SINE);
        keys.add(RAMP);
        keys.add(RANDOM);
        KEYS = Collections.unmodifiableList(keys);
    }

    @Override
    public Collection<String> getVariables() {
        return KEYS;
    }

    public void start() {
        this.thread = new Thread(){

            @Override
            public void run() {
                PseudoSolver.this.startTime = System.nanoTime();
                PseudoSolver.this.notifyStep();
                while (Thread.currentThread() == PseudoSolver.this.thread) {
                    PseudoSolver.this.writeLock.lock();
                    try {
                        if (Thread.currentThread() != PseudoSolver.this.thread) {
                            return;
                        }
                        int i = 0;
                        while (i < 10) {
                            ++PseudoSolver.this.cycle;
                            PseudoSolver.this.time = (double)PseudoSolver.this.cycle * 0.01;
                            PseudoSolver.this.notifyStep();
                            ++i;
                        }
                    }
                    finally {
                        PseudoSolver.this.writeLock.unlock();
                    }
                    try {
                        Thread.sleep(15L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        };
        this.thread.start();
    }

    public void stop() {
        this.writeLock.lock();
        try {
            this.thread = null;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public Datatype getType(String key) {
        return Datatypes.DOUBLE;
    }

    @Override
    public Object getTime(NumberBinding binding) {
        try {
            return binding.create((Number)this.time);
        }
        catch (BindingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public VariableHandle openHandle(Bean item, String key, Binding valueBinding) {
        this.getValue(key, valueBinding);
        return new MyVariableHandle(key, valueBinding);
    }

    public Object getValue(String key, Binding binding) {
        if (!(binding instanceof NumberBinding)) {
            throw new IllegalArgumentException("binding must be NumberBinding");
        }
        NumberBinding nb = (NumberBinding)binding;
        try {
            if (key.equals(SINE)) {
                double value = Math.sin(this.time);
                return nb.create((Number)value);
            }
            if (key.equals(RAMP)) {
                boolean up = this.time - Math.floor(this.time) >= 0.5;
                double value = up ? 1.0 : 0.0;
                return value;
            }
            if (key.equals(RANDOM)) {
                return this.random.nextDouble() * 10.0;
            }
        }
        catch (BindingException e) {
            throw new RuntimeException(e);
        }
        throw new RuntimeException("Unknown variable " + key);
    }

    class MyVariableHandle
    implements VariableHandle {
        String key;
        Binding b;

        public MyVariableHandle(String key, Binding b) {
            this.b = b;
            this.key = key;
        }

        @Override
        public String key() {
            return this.key;
        }

        @Override
        public Binding binding() {
            return this.b;
        }

        @Override
        public Object getValue() {
            return PseudoSolver.this.getValue(this.key, this.b);
        }

        @Override
        public void dispose() {
        }
    }
}

