/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.utils.threads.ua;

import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.simantics.utils.threads.ua.IStatefulObject;
import org.simantics.utils.threads.ua.StateListener;

public abstract class AbstractState<StateType, ErrorType extends Throwable>
implements IStatefulObject<StateType, ErrorType> {
    private StateType state = null;
    private StateType errorState = null;
    private ErrorType errorCause;
    private StateListener<StateType> firstListener = null;
    private CopyOnWriteArrayList<StateListener<StateType>> listenerList = null;
    private Object lock = new Object();

    public AbstractState(StateType initialState) {
        this.state = initialState;
    }

    public AbstractState(StateType initialState, StateType errorState) {
        this.state = initialState;
        this.errorState = errorState;
    }

    @Override
    public synchronized StateType getState() {
        return this.state;
    }

    protected StateType attemptSetState(Set<StateType> prerequisiteState, StateType newState) {
        if (prerequisiteState == null || newState == null) {
            throw new IllegalArgumentException("null arg");
        }
        return this.setState(newState, null, prerequisiteState);
    }

    @Override
    public synchronized void addStateListener(StateListener<StateType> listener) {
        if (listener == null) {
            throw new IllegalArgumentException("null arg");
        }
        if (this.listenerList != null) {
            this.listenerList.add(listener);
            return;
        }
        if (this.firstListener == null) {
            this.firstListener = listener;
            return;
        }
        this.listenerList = new CopyOnWriteArrayList();
        this.listenerList.add(listener);
    }

    @Override
    public void removeStateListener(StateListener<StateType> listener) {
        if (listener == null) {
            throw new IllegalArgumentException("null arg");
        }
        if (this.listenerList != null) {
            this.listenerList.remove(listener);
            if (this.listenerList.isEmpty()) {
                this.listenerList = null;
            }
            return;
        }
        if (listener == this.firstListener) {
            this.firstListener = null;
        }
    }

    protected boolean setState(StateType state) {
        return this.setState(state, null, null) == state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setError(ErrorType error) {
        this.errorCause = error;
        if (this.errorState == null || !this.setState(this.errorState)) {
            Object object = this.lock;
            synchronized (object) {
                this.lock.notifyAll();
            }
        }
    }

    protected void clearError() {
        this.errorCause = null;
    }

    @Override
    public ErrorType getError() {
        return this.errorCause;
    }

    public boolean hasError() {
        return this.errorCause != null;
    }

    protected void assertNoError() throws ErrorType {
        ErrorType e = this.errorCause;
        if (e != null) {
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected StateType setState(StateType state, Executor listenerExecutor, Set<StateType> prerequisiteStates) {
        boolean hasListeners;
        StateListener<Object> fl = null;
        Object oldState = null;
        Object newState = null;
        AbstractState abstractState = this;
        synchronized (abstractState) {
            oldState = this.state;
            newState = state;
            if (oldState == newState) {
                return state;
            }
            if (prerequisiteStates != null && !prerequisiteStates.contains(this.state)) {
                return state;
            }
            if (!this.isStateTransitionAllowed(oldState, newState)) {
                return state;
            }
            this.state = newState;
            fl = this.firstListener;
            hasListeners = fl != null || this.listenerList != null && !this.listenerList.isEmpty();
        }
        final StateListener<Object> fl_ = fl;
        Object object = this.lock;
        synchronized (object) {
            this.lock.notifyAll();
        }
        this.onStateTransition(oldState, newState);
        if (hasListeners) {
            final Object os = oldState;
            final Object ns = newState;
            if (fl != null) {
                if (listenerExecutor == null) {
                    try {
                        fl.onStateTransition(this, oldState, newState);
                    }
                    catch (RuntimeException runtimeException) {
                        this.onListenerException(runtimeException);
                    }
                } else {
                    listenerExecutor.execute(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                fl_.onStateTransition(AbstractState.this, os, ns);
                            }
                            catch (RuntimeException e) {
                                AbstractState.this.onListenerException(e);
                            }
                        }
                    });
                }
            }
            if (this.listenerList != null && !this.listenerList.isEmpty()) {
                for (final StateListener<Object> stateListener : this.listenerList) {
                    if (listenerExecutor == null) {
                        try {
                            stateListener.onStateTransition(this, oldState, newState);
                        }
                        catch (RuntimeException e) {
                            this.onListenerException(e);
                        }
                        continue;
                    }
                    listenerExecutor.execute(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                stateListener.onStateTransition(AbstractState.this, os, ns);
                            }
                            catch (RuntimeException e) {
                                AbstractState.this.onListenerException(e);
                            }
                        }
                    });
                }
            }
        }
        return state;
    }

    protected boolean isStateTransitionAllowed(StateType oldState, StateType newState) {
        return true;
    }

    protected void onStateTransition(StateType oldState, StateType newState) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StateType waitForState(Set<StateType> set) throws InterruptedException, ErrorType {
        Object object = this.lock;
        synchronized (object) {
            while (!set.contains(this.state)) {
                this.lock.wait();
            }
            ErrorType e = this.getError();
            if (e != null) {
                throw e;
            }
            return this.state;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public StateType waitForStateUninterruptibly(Set<StateType> set) throws ErrorType {
        Object object = this.lock;
        synchronized (object) {
            while (true) {
                if (set.contains(this.state)) {
                    ErrorType e = this.getError();
                    if (e == null) break;
                    throw e;
                }
                try {
                    this.lock.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            return this.state;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StateType waitForState(Set<StateType> set, long timeout, TimeUnit unit) throws InterruptedException, TimeoutException, ErrorType {
        long abortTime = System.currentTimeMillis() + unit.toMillis(timeout);
        Object object = this.lock;
        synchronized (object) {
            while (!set.contains(this.state)) {
                long waitTime = System.currentTimeMillis() - abortTime;
                if (waitTime < 0L) {
                    throw new TimeoutException("timeout");
                }
                this.lock.wait(waitTime);
                ErrorType e = this.getError();
                if (e == null) continue;
                throw e;
            }
            return this.state;
        }
    }

    protected void onListenerException(RuntimeException rte) {
        rte.printStackTrace();
    }
}

