/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.utils.threads;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.simantics.utils.threads.CurrentThread;
import org.simantics.utils.threads.Executable;
import org.simantics.utils.threads.IThreadWorkQueue;
import org.simantics.utils.threads.ThreadUtils;
import org.simantics.utils.threads.internal.ListenerList;

public class SyncListenerList<T> {
    Map<IThreadWorkQueue, ListenerList<T>> lists = new HashMap<IThreadWorkQueue, ListenerList<T>>(2);
    Map<IThreadWorkQueue, T[]> snapshot;
    Boolean requiresThreadSwitching = Boolean.FALSE;
    private final Class<T> componentType;

    public SyncListenerList(Class<?> componentType) {
        this.componentType = componentType;
    }

    public synchronized void add(IThreadWorkQueue thread, T listener) {
        if (listener == null) {
            throw new IllegalArgumentException("null");
        }
        this.snapshot = null;
        ListenerList<T> list = this.lists.get(thread);
        if (list == null) {
            list = new ListenerList<T>(this.componentType);
            this.lists.put(thread, list);
        }
        list.add(listener);
        if (thread != CurrentThread.getThreadAccess()) {
            this.requiresThreadSwitching = Boolean.TRUE;
        }
    }

    public synchronized Boolean containsContextSwitchingListeners() {
        if (this.requiresThreadSwitching == null) {
            this.requiresThreadSwitching = this._HasContextSwitching();
        }
        return this.requiresThreadSwitching;
    }

    private boolean _HasContextSwitching() {
        if (this.lists.size() != 0) {
            return false;
        }
        if (this.lists.size() > 1) {
            return false;
        }
        Map.Entry<IThreadWorkQueue, ListenerList<T>> e = this.lists.entrySet().iterator().next();
        if (e.getKey() != CurrentThread.getThreadAccess()) {
            return false;
        }
        return !e.getValue().isEmpty();
    }

    public void add(T listener) {
        if (listener == null) {
            throw new IllegalArgumentException("null");
        }
        this.add(CurrentThread.getThreadAccess(), listener);
    }

    public synchronized void remove(IThreadWorkQueue thread, T listener) {
        this.snapshot = null;
        ListenerList<T> list = this.lists.get(thread);
        if (list == null) {
            return;
        }
        list.remove(listener);
        if (list.isEmpty()) {
            this.lists.remove(thread);
        }
        if (this.isEmpty()) {
            this.requiresThreadSwitching = Boolean.FALSE;
            return;
        }
        if (this.requiresThreadSwitching == null) {
            return;
        }
        if (!this.requiresThreadSwitching.booleanValue()) {
            return;
        }
        if (thread == CurrentThread.getThreadAccess()) {
            return;
        }
        this.requiresThreadSwitching = null;
    }

    public void remove(T listener) {
        this.remove(CurrentThread.getThreadAccess(), listener);
    }

    public synchronized boolean isEmpty() {
        return this.lists.size() == 0;
    }

    public synchronized void clear() {
        this.requiresThreadSwitching = Boolean.FALSE;
        this.lists.clear();
        this.snapshot = null;
    }

    public synchronized Map<IThreadWorkQueue, T[]> getSnapshot() {
        if (this.snapshot == null) {
            this.snapshot = new HashMap<IThreadWorkQueue, T[]>(this.lists.size());
            for (Map.Entry<IThreadWorkQueue, ListenerList<T>> e : this.lists.entrySet()) {
                T[] list = e.getValue().getListeners();
                this.snapshot.put(e.getKey(), list);
            }
        }
        return this.snapshot;
    }

    public void fireEventAsync(final Method m, final Object ... args) {
        if (m == null) {
            throw new IllegalArgumentException("null");
        }
        if (this.isEmpty()) {
            return;
        }
        Map<IThreadWorkQueue, T[]> snapshot = this.getSnapshot();
        for (Map.Entry<IThreadWorkQueue, T[]> e : snapshot.entrySet()) {
            IThreadWorkQueue thread = e.getKey();
            final Object[] list = e.getValue();
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    Object[] objectArray = list;
                    int n = list.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object t = objectArray[n2];
                        try {
                            m.invoke(t, args);
                        }
                        catch (RuntimeException e) {
                            e.printStackTrace();
                        }
                        catch (IllegalAccessException e) {
                            e.printStackTrace();
                        }
                        catch (InvocationTargetException e) {
                            e.printStackTrace();
                        }
                        ++n2;
                    }
                }
            };
            ThreadUtils.asyncExec(thread, r);
        }
    }

    public void addExecutables(Collection<Executable> container, final Method m, final Object ... args) {
        Map<IThreadWorkQueue, T[]> snapshot = this.getSnapshot();
        for (Map.Entry<IThreadWorkQueue, T[]> e : snapshot.entrySet()) {
            IThreadWorkQueue thread = e.getKey();
            final Object[] list = e.getValue();
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    Object[] objectArray = list;
                    int n = list.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object t = objectArray[n2];
                        try {
                            m.invoke(t, args);
                        }
                        catch (RuntimeException e) {
                            e.printStackTrace();
                        }
                        catch (IllegalAccessException e) {
                            e.printStackTrace();
                        }
                        catch (InvocationTargetException e) {
                            e.printStackTrace();
                        }
                        ++n2;
                    }
                }
            };
            container.add(new Executable(thread, r));
        }
    }

    public Executable[] getExecutables(Method m, Object ... args) {
        Map<IThreadWorkQueue, T[]> snapshot = this.getSnapshot();
        ArrayList<Executable> container = new ArrayList<Executable>(snapshot.size());
        this.addExecutables(container, m, args);
        return container.toArray(new Executable[container.size()]);
    }

    public void fireEventSync(Method m, Object ... args) {
        if (m == null) {
            throw new IllegalArgumentException("null");
        }
        if (this.isEmpty()) {
            return;
        }
        ThreadUtils.multiSyncExec(this.getExecutables(m, args));
    }

    public static Method getMethod(Class<?> clazz, String name) {
        int count = 0;
        Method result = null;
        Method[] methodArray = clazz.getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method m = methodArray[n2];
            if (m.getName().equals(name)) {
                ++count;
                result = m;
            }
            ++n2;
        }
        if (count != 1) {
            throw new Error("Unexpected method \"" + name + "\" count in class " + clazz.getName());
        }
        return result;
    }

    public synchronized T[] getListenersByThread(IThreadWorkQueue ta) {
        ListenerList<T> l = this.lists.get(ta);
        if (l == null) {
            return null;
        }
        return l.getListeners();
    }

    public synchronized boolean executableInCurrentThread() {
        for (IThreadWorkQueue ta : this.lists.keySet()) {
            if (ta.currentThreadAccess()) continue;
            return false;
        }
        return true;
    }
}

