/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.ui.workbench.project;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PartInitException;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Write;
import org.simantics.project.ProjectElementType;
import org.simantics.project.exception.UnsupportedProjectObjectException;
import org.simantics.ui.workbench.project.UIModelManager;
import org.simantics.utils.datastructures.Callback;

public class UIModelManagerBase
implements UIModelManager {
    public static void safeRun(ISafeRunnable runnable, Callback<Throwable> errorCallback) {
        try {
            runnable.run();
        }
        catch (Exception e) {
            errorCallback.run((Object)e);
        }
        catch (LinkageError e) {
            errorCallback.run((Object)e);
        }
    }

    @Override
    public void create(ProjectElementType kind, Shell parentShell, Session session, Resource container, Callback<Resource> callback, Callback<Throwable> errorCallback) {
        errorCallback.run((Object)new UnsupportedProjectObjectException(kind));
    }

    @Override
    public void openEditor(Session session, String uri) throws PartInitException {
    }

    protected void request(Session session, final Resource container, final Callback<Resource> callback, final Callback<Throwable> errorCallback, final WriteRunnable runnable) {
        this.request(session, errorCallback, (Write)new WriteRequest(){

            public void perform(WriteGraph graph) throws DatabaseException {
                runnable.run(graph, container, (Callback<Resource>)callback, (Callback<Throwable>)errorCallback);
            }
        });
    }

    protected void request(Session session, Callback<Throwable> errorCallback, Write writeRequest) {
        try {
            session.syncRequest(writeRequest);
        }
        catch (DatabaseException e) {
            errorCallback.run((Object)e);
        }
    }

    protected void request(final String requestName, final Session session, final Callback<Throwable> errorCallback, final Write writeRequest) {
        Job job = new Job(requestName){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    session.syncRequest(writeRequest);
                    return Status.OK_STATUS;
                }
                catch (DatabaseException e) {
                    errorCallback.run((Object)e);
                    return new Status(4, "org.simantics.ui", String.valueOf(requestName) + " failed.", (Throwable)e);
                }
            }
        };
        job.setUser(true);
        job.schedule();
    }

    public static abstract class SafeRunnable
    implements ISafeRunnable {
        public void handleException(Throwable exception) {
        }
    }

    public static interface WriteRunnable {
        public void run(WriteGraph var1, Resource var2, Callback<Resource> var3, Callback<Throwable> var4);
    }
}

