/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.ui.workbench.preferences;

import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.simantics.ui.workbench.WorkbenchResources;

public class NumberFieldEditor
extends StringFieldEditor {
    private double minValidValue = 0.0;
    private double maxValidValue = Double.MAX_VALUE;
    private static final int DEFAULT_TEXT_LIMIT = 10;

    protected NumberFieldEditor() {
    }

    public NumberFieldEditor(String name, String labelText, Composite parent) {
        this(name, labelText, parent, 10);
    }

    public NumberFieldEditor(String name, String labelText, Composite parent, int textLimit) {
        this.init(name, labelText);
        this.setTextLimit(textLimit);
        this.setEmptyStringAllowed(false);
        this.setErrorMessage(WorkbenchResources.getString("NumberFieldEditor.errorMessage"));
        this.createControl(parent);
    }

    public void setValidRange(double min, double max) {
        this.minValidValue = min;
        this.maxValidValue = max;
        this.setErrorMessage(WorkbenchResources.format("NumberFieldEditor.errorMessageRange", new Object[]{new Double(min), new Double(max)}));
    }

    protected boolean checkState() {
        block4: {
            Text text = this.getTextControl();
            if (text == null) {
                return false;
            }
            String numberString = text.getText();
            try {
                double number = Double.parseDouble(numberString);
                if (!(number >= this.minValidValue) || !(number <= this.maxValidValue)) break block4;
                this.clearErrorMessage();
                return true;
            }
            catch (NumberFormatException e1) {
                this.showErrorMessage();
                return false;
            }
        }
        this.showErrorMessage();
        return false;
    }

    protected void doLoad() {
        Text text = this.getTextControl();
        if (text != null) {
            double value = this.getPreferenceStore().getDouble(this.getPreferenceName());
            text.setText("" + value);
            this.oldValue = "" + value;
        }
    }

    protected void doLoadDefault() {
        Text text = this.getTextControl();
        if (text != null) {
            double value = this.getPreferenceStore().getDefaultDouble(this.getPreferenceName());
            text.setText("" + value);
        }
        this.valueChanged();
    }

    protected void doStore() {
        Text text = this.getTextControl();
        if (text != null) {
            this.getPreferenceStore().setValue(this.getPreferenceName(), Double.parseDouble(text.getText()));
        }
    }

    public double getDoubleValue() throws NumberFormatException {
        return Double.parseDouble(this.getStringValue());
    }
}

