/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.ui.workbench.handler;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.simantics.Simantics;
import org.simantics.db.ChangeSetIdentifier;
import org.simantics.db.Operation;
import org.simantics.db.Session;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.NoHistoryException;
import org.simantics.db.service.ManagementSupport;
import org.simantics.db.service.UndoRedoSupport;
import org.simantics.ui.workbench.handler.SessionUndoHandler;
import org.simantics.utils.ui.workbench.WorkbenchUtils;

public class SessionRedoHandler
extends AbstractHandler {
    private final boolean DEBUG = false;

    public Object execute(ExecutionEvent e) throws ExecutionException {
        IWorkbenchPart part = HandlerUtil.getActivePart((ExecutionEvent)e);
        if (part == null) {
            return null;
        }
        IActionBars actionBars = WorkbenchUtils.getActionBars((IWorkbenchPart)part);
        final Session session = Simantics.peekSession();
        if (session == null) {
            return null;
        }
        try {
            final AtomicReference msg = new AtomicReference();
            IRunnableWithProgress redo = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        try {
                            monitor.beginTask("Redo", -1);
                            msg.set(SessionRedoHandler.this.redo(session));
                        }
                        catch (NoHistoryException e) {
                            msg.set("Nothing to redo.");
                            monitor.done();
                        }
                        catch (DatabaseException e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
            };
            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            new ProgressMonitorDialog(shell).run(true, false, redo);
            actionBars.getStatusLineManager().setMessage((String)msg.get());
        }
        catch (InvocationTargetException e1) {
            throw new ExecutionException("Redo failed, database failure.", e1.getTargetException());
        }
        catch (InterruptedException e1) {
            throw new ExecutionException("Redo failed, interrupted.", (Throwable)e1);
        }
        return null;
    }

    private String redo(Session session) throws DatabaseException {
        UndoRedoSupport support = (UndoRedoSupport)session.getService(UndoRedoSupport.class);
        List ops = support.redo(session, 1);
        if (ops.isEmpty()) {
            return "Nothing to redo.";
        }
        Operation mainOperation = (Operation)ops.get(0);
        String msg = null;
        long csId = mainOperation.getCSId();
        ManagementSupport management = (ManagementSupport)session.getService(ManagementSupport.class);
        for (ChangeSetIdentifier id : management.getChangeSetIdentifiers(csId, csId)) {
            if (msg != null) continue;
            msg = "Redid: " + SessionUndoHandler.getComment(session, id);
        }
        return msg;
    }
}

