/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.ui.workbench;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.AdaptionException;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.ui.workbench.EditorNaming;
import org.simantics.ui.workbench.IEditorNamingService;
import org.simantics.ui.workbench.IResourceEditorInput;

public class TitleRequest
implements Read<String> {
    private final String editorId;
    private final IResourceEditorInput input;

    public TitleRequest(String editorId, IResourceEditorInput input) {
        this.editorId = editorId;
        this.input = input;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String perform(ReadGraph graph) throws DatabaseException {
        Resource r;
        block4: {
            r = this.input.getResource();
            try {
                String n = null;
                IEditorNamingService ems = EditorNaming.getNamingService(graph, r);
                if (ems != null) {
                    n = ems.getName(graph, this.editorId, this.input);
                }
                if (n != null) return n;
                if (r != null) break block4;
                return "no input resource";
            }
            catch (AdaptionException e) {
                return NameUtils.getSafeName((ReadGraph)graph, (Resource)r);
            }
        }
        return (String)graph.adapt(r, String.class);
    }
}

