/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.ui.workbench;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorPart;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.common.request.ParametrizedRead;
import org.simantics.db.management.ISessionContext;
import org.simantics.db.procedure.Listener;
import org.simantics.db.request.Read;
import org.simantics.ui.SimanticsUI;
import org.simantics.ui.workbench.IResourceEditorInput;
import org.simantics.ui.workbench.IResourceEditorPart;
import org.simantics.ui.workbench.ResourceEditorSupport;
import org.simantics.ui.workbench.TitleRequest;
import org.simantics.ui.workbench.TitleUpdater;
import org.simantics.ui.workbench.ToolTipRequest;
import org.simantics.utils.datastructures.Callable;
import org.simantics.utils.datastructures.Callback;

public abstract class ResourceEditorPart
extends EditorPart
implements IResourceEditorPart {
    protected boolean disposed = false;
    protected ResourceEditorSupport support;

    protected ParametrizedRead<IResourceEditorInput, Boolean> getInputValidator() {
        return null;
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.init(site, input, this.getInputValidator());
    }

    protected void createSupport(ParametrizedRead<IResourceEditorInput, Boolean> inputValidator) throws PartInitException {
        this.support = new ResourceEditorSupport(this, inputValidator);
    }

    protected void init(IEditorSite site, IEditorInput input, ParametrizedRead<IResourceEditorInput, Boolean> inputValidator) throws PartInitException {
        if (!(input instanceof IResourceEditorInput)) {
            throw new PartInitException("Invalid input: must be IResourceEditorInput");
        }
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        this.createSupport(inputValidator);
        this.setPartName(this.getEditorInput().getName());
        Session session = SimanticsUI.peekSession();
        if (session != null) {
            Callable<Boolean> disposedCallback = new Callable<Boolean>(){

                public Boolean call() {
                    return ResourceEditorPart.this.disposed;
                }
            };
            session.asyncRequest((Read)new TitleRequest(site.getId(), this.getResourceInput()), (Listener)new TitleUpdater(site.getShell().getDisplay(), new Callback<String>(){

                public void run(String partName) {
                    ResourceEditorPart.this.setPartName(partName);
                }
            }, disposedCallback));
            session.asyncRequest((Read)new ToolTipRequest(site.getId(), this.getResourceInput()), (Listener)new TitleUpdater(site.getShell().getDisplay(), new Callback<String>(){

                public void run(String toolTip) {
                    ResourceEditorPart.this.setTitleToolTip(toolTip);
                }
            }, disposedCallback));
        }
    }

    public void dispose() {
        this.disposed = true;
        this.support.dispose();
        super.dispose();
    }

    protected void activateValidation() {
        this.support.activateValidation();
    }

    public ISessionContext getSessionContext() {
        return this.support.getSessionContext();
    }

    public Session getSession() {
        return this.support.getSession();
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public final void doSaveAs() {
    }

    public final boolean isDirty() {
        return false;
    }

    public final boolean isSaveAsAllowed() {
        return false;
    }

    @Override
    public IResourceEditorInput getResourceInput() {
        return (IResourceEditorInput)this.getEditorInput();
    }

    public IStatusLineManager getStatusLineManager() {
        IActionBars bars = this.getEditorSite().getActionBars();
        IStatusLineManager mgr = bars.getStatusLineManager();
        return mgr;
    }

    public void setStatusMessage(String message) {
        this.getStatusLineManager().setMessage(message);
    }

    public void setStatusErrorMessage(String message) {
        this.getStatusLineManager().setErrorMessage(message);
    }

    protected Resource getInputResource() {
        return this.getResourceInput().getResource();
    }

    protected String getInputName() {
        return this.getEditorInput().getName();
    }

    protected String getTitleText() {
        return this.getInputName();
    }

    protected String getTitleTooltip() {
        return this.getInputName();
    }

    protected void updateTitle() {
        this.setPartName(this.getTitleText());
        this.setTitleToolTip(this.getTitleTooltip());
    }

    protected void asyncExec(Runnable run) {
        this.getSite().getShell().getDisplay().asyncExec(run);
    }

    public Object getAdapter(Class adapter) {
        if (adapter == Session.class) {
            return this.getSession();
        }
        return super.getAdapter(adapter);
    }
}

