/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.ui.workbench;

import java.util.ArrayList;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.ui.IElementFactory;
import org.eclipse.ui.IMemento;
import org.simantics.ui.workbench.ResourceEditorInput2;
import org.simantics.utils.ui.ErrorLogger;
import org.simantics.utils.ui.workbench.StringMemento;

public class ResourceEditorInputFactory2
implements IElementFactory {
    private static final String ID_FACTORY = "org.simantics.ui.workbench.resourceEditorInputFactory2";
    public static final String TAG_RESOURCE_ID = "resourceId";
    public static final String TAG_EDITOR_ID = "editorId";
    public static final String TAG_MODEL_ID = "modelId";
    public static final String TAG_RVI = "rvi";
    public static final String TAG_EXTERNAL_MEMENTO_ID = "external";

    public IAdaptable createElement(IMemento memento) {
        IMemento[] children = memento.getChildren(TAG_RESOURCE_ID);
        if (children.length != 1) {
            return null;
        }
        ArrayList<String> ids = new ArrayList<String>();
        IMemento[] iMementoArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IMemento child = iMementoArray[n2];
            ids.add(child.getTextData());
            ++n2;
        }
        String editorId = memento.getString(TAG_EDITOR_ID);
        String modelId = memento.getString(TAG_MODEL_ID);
        String rvi = memento.getString(TAG_RVI);
        try {
            ResourceEditorInput2 result = new ResourceEditorInput2(editorId, (String)ids.iterator().next(), modelId, rvi);
            String externalMementoStr = memento.getString(TAG_EXTERNAL_MEMENTO_ID);
            if (externalMementoStr != null) {
                StringMemento sm = new StringMemento(externalMementoStr);
                sm.writeToMemento(result.getPersistentStore());
            }
            return result;
        }
        catch (NumberFormatException e) {
            return null;
        }
        catch (IllegalArgumentException e) {
            ErrorLogger.defaultLogError((Throwable)e);
            return null;
        }
    }

    public static String getFactoryId() {
        return ID_FACTORY;
    }
}

