/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.ui.jobs;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.simantics.DatabaseJob;
import org.simantics.Simantics;
import org.simantics.db.Session;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.util.SessionGarbageCollection;
import org.simantics.db.service.LifecycleSupport;
import org.simantics.utils.datastructures.Callback;
import org.simantics.utils.ui.ErrorLogger;

public class SessionGarbageCollectorJob
extends Job {
    private static SessionGarbageCollectorJob instance;
    private static final boolean TRACE = false;
    private static final long DEFAULT_QUIET_TIME = 60000L;
    private long start;
    private long quietTime;
    private boolean enabled = true;
    Callback<DatabaseException> errorCallback = new Callback<DatabaseException>(){

        public void run(DatabaseException e) {
            ErrorLogger.defaultLogError((Throwable)e);
        }
    };

    public static synchronized SessionGarbageCollectorJob getInstance() {
        if (instance == null) {
            instance = new SessionGarbageCollectorJob();
        }
        return instance;
    }

    public SessionGarbageCollectorJob() {
        this(60000L);
    }

    public SessionGarbageCollectorJob(long delayBetweenExecutions) {
        super("Database Garbage Collector");
        this.setPriority(50);
        this.setSystem(true);
        this.start = System.currentTimeMillis();
        this.quietTime = delayBetweenExecutions;
    }

    public void rescheduleAfterQuietTime() {
        this.cancel();
        this.scheduleAfterQuietTime();
    }

    public void rescheduleNow() {
        this.cancel();
        this.schedule();
    }

    public SessionGarbageCollectorJob setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public SessionGarbageCollectorJob setQuietTime(long quietTime) {
        this.quietTime = quietTime;
        return this;
    }

    public void scheduleAfterQuietTime() {
        this.schedule(this.quietTime);
    }

    public boolean shouldSchedule() {
        return this.enabled;
    }

    public boolean shouldRun() {
        return this.enabled;
    }

    protected IStatus run(IProgressMonitor monitor) {
        long interval = this.quietTime;
        try {
            Session session = Simantics.peekSession();
            if (session == null) {
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
            LifecycleSupport lfs = (LifecycleSupport)session.peekService(LifecycleSupport.class);
            if (lfs == null) {
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
            if (lfs.isClosed()) {
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
            if (DatabaseJob.inProgress()) {
                interval = Math.min(10L, this.quietTime);
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
            long begin = System.currentTimeMillis();
            SessionGarbageCollection.gc((IProgressMonitor)monitor, (Session)session, (boolean)true, this.errorCallback);
            long intermediate = System.currentTimeMillis();
            IStatus iStatus = Status.OK_STATUS;
            return iStatus;
        }
        finally {
            this.schedule(interval);
            monitor.done();
        }
    }
}

