/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.ui.internal;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.widgets.Display;
import org.simantics.db.ServerAddress;
import org.simantics.db.authentication.UserAuthenticationAgent;
import org.simantics.db.authentication.UserAuthenticator;
import org.simantics.db.common.auth.UserAuthenticationAgents;
import org.simantics.db.common.auth.UserAuthenticators;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.InvalidAuthenticationException;
import org.simantics.db.exception.InvalidUserException;
import org.simantics.db.management.ISessionContext;
import org.simantics.db.management.SessionContext;
import org.simantics.db.management.discovery.ServerInfo;
import org.simantics.db.service.ServerInformation;
import org.simantics.internal.TimedSessionCache;
import org.simantics.ui.SimanticsUI;
import org.simantics.ui.auth.AuthenticationUtils;
import org.simantics.ui.auth.model.LoginModel;
import org.simantics.ui.internal.Activator;
import org.simantics.ui.internal.LoginCancelledException;
import org.simantics.utils.DataContainer;
import org.simantics.utils.datastructures.cache.SoftTimedCache;
import org.simantics.utils.threads.IThreadWorkQueue;
import org.simantics.utils.threads.SWTThread;
import org.simantics.utils.threads.ThreadUtils;

@Deprecated
public final class SessionUtils {
    public static void releaseUnusedSessionAfterHoldTime(ISessionContext ctx) {
        SessionUtils.releaseUnusedSessionAfterHoldTime(ctx, 10000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void releaseUnusedSessionAfterHoldTime(ISessionContext ctx, long holdTime) {
        if (ctx == null) {
            throw new IllegalArgumentException("null session context");
        }
        if (SimanticsUI.isInUse(ctx)) {
            return;
        }
        Class<SessionUtils> clazz = SessionUtils.class;
        synchronized (SessionUtils.class) {
            TimedSessionCache cache = TimedSessionCache.getCache();
            for (SoftTimedCache.CacheEntry e : cache.getEntries()) {
                e.schedule(holdTime, TimeUnit.MILLISECONDS);
            }
            TimedSessionCache.getCache().put((Object)ctx.getAddress(), (Object)ctx, 5L, TimeUnit.MINUTES);
            // ** MonitorExit[var3_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ISessionContext releaseFromCache(ServerAddress address) {
        Class<SessionUtils> clazz = SessionUtils.class;
        synchronized (SessionUtils.class) {
            ISessionContext cachedCtx = (ISessionContext)TimedSessionCache.getCache().release((Object)address);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return cachedCtx;
        }
    }

    static ISessionContext getSessionContext(IProgressMonitor monitor, ServerInfo server, UserAuthenticator auth) throws DatabaseException, IOException {
        return SessionUtils.getSessionContext(monitor, server, auth, true);
    }

    static ISessionContext getSessionContext(IProgressMonitor monitor, ServerInfo server) throws DatabaseException, IOException {
        return SessionUtils.getSessionContext(monitor, server, null, true);
    }

    static ISessionContext getSessionContext(IProgressMonitor monitor, ServerInfo server, UserAuthenticator auth, boolean registerServices) throws DatabaseException, IOException {
        return SessionUtils.getSessionContext(monitor, server.getAddress(), auth, registerServices);
    }

    static ISessionContext getSessionContext(IProgressMonitor monitor, ServerInfo server, boolean registerServices) throws DatabaseException, IOException {
        return SessionUtils.getSessionContext(monitor, server.getAddress(), null, registerServices);
    }

    static ISessionContext getSessionContext(IProgressMonitor monitor, ServerAddress address, boolean registerServices) throws DatabaseException, IOException {
        return SessionUtils.getSessionContext(monitor, address, null, registerServices);
    }

    static ISessionContext getSessionContext(IProgressMonitor monitor, ServerAddress address, UserAuthenticator auth, boolean registerServices) throws DatabaseException, IOException {
        return SessionUtils.getSessionContext(monitor, address, auth, registerServices, false);
    }

    static synchronized ISessionContext getSessionContext(IProgressMonitor monitor, final ServerAddress address, UserAuthenticator auth, boolean registerServices, boolean forceReload) throws DatabaseException, IOException {
        if (!forceReload) {
            ISessionContext newCtx = SimanticsUI.getSessionContext();
            if (newCtx != null && address.equals((Object)newCtx.getAddress())) {
                return newCtx;
            }
            ISessionContext cachedCtx = SessionUtils.releaseFromCache(address);
            if (cachedCtx != null) {
                if (registerServices && cachedCtx instanceof SessionContext) {
                    SessionUtils.safeRegisterServices((SessionContext)cachedCtx);
                }
                return cachedCtx;
            }
        }
        if (monitor != null) {
            monitor.subTask("Connecting to database at " + address);
        }
        boolean success = false;
        boolean lastFailed = false;
        SessionContext ctx = null;
        UserAuthenticationAgent agent = null;
        if (auth != null) {
            agent = UserAuthenticationAgents.staticAgent((UserAuthenticator)auth);
        }
        while (!success) {
            final DataContainer loginModel = new DataContainer();
            final DataContainer serverInfo = new DataContainer();
            if (agent == null) {
                final boolean forceQuery = lastFailed;
                agent = new UserAuthenticationAgent(){

                    public UserAuthenticator getAuthenticator(ServerInformation information) throws IOException {
                        final DataContainer authenticator = new DataContainer();
                        serverInfo.set((Object)new ServerInfo("", address, information));
                        ThreadUtils.syncExec((IThreadWorkQueue)SWTThread.getThreadAccess((Display)Display.getDefault()), (Runnable)new Runnable(){

                            @Override
                            public void run() {
                                LoginModel model = AuthenticationUtils.queryAuthenticationInfo(Display.getDefault().getActiveShell(), (ServerInfo)serverInfo.get(), forceQuery);
                                if (model != null) {
                                    loginModel.set((Object)model);
                                    authenticator.set((Object)UserAuthenticators.byNameAndPassword((String)model.getName(), (String)model.getPassword()));
                                }
                            }
                        });
                        if (authenticator.get() == null) {
                            throw new LoginCancelledException("User authentication was not provided.");
                        }
                        return (UserAuthenticator)authenticator.get();
                    }
                };
            }
            try {
                ctx = SessionContext.openAndInitializeSession((ServerAddress)address, (UserAuthenticationAgent)agent);
                success = true;
                LoginModel lm = (LoginModel)loginModel.get();
                if (lm == null || !lm.isRemember() || lm.isLoadedFromStore()) continue;
                AuthenticationUtils.storeAuthenticationInfo((ServerInfo)serverInfo.get(), lm);
            }
            catch (IOException e) {
                lastFailed = true;
                Throwable cause = e.getCause();
                if (cause instanceof InvalidAuthenticationException) {
                    agent = null;
                    continue;
                }
                if (cause instanceof InvalidUserException) {
                    agent = null;
                    continue;
                }
                throw e;
            }
            catch (DatabaseException e) {
                e.printStackTrace();
                throw e;
            }
        }
        if (registerServices) {
            if (monitor != null) {
                monitor.subTask("Registering session services");
            }
            SessionUtils.safeRegisterServices(ctx);
        }
        SessionContext newCtx = ctx;
        return newCtx;
    }

    private static void safeRegisterServices(final SessionContext ctx) {
        SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

            public void handleException(Throwable exception) {
                Activator.getDefault().getLog().log((IStatus)new Status(4, "org.simantics.ui", "Database session service registration produced unexpected error", exception));
            }

            public void run() {
                ctx.registerServices();
            }
        });
    }

    static synchronized void replaceUISession(ISessionContext newContext) {
        ISessionContext oldContext = SimanticsUI.setSessionContext(newContext);
        if (oldContext != null) {
            SessionUtils.releaseUnusedSessionAfterHoldTime(oldContext);
        }
    }
}

