/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.ui.dnd;

import fi.vtt.simantics.procore.ProCoreServerReference;
import fi.vtt.simantics.procore.ProCoreSessionReference;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.ui.IMemento;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.SessionReference;
import org.simantics.db.common.ResourceArray;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.service.LifecycleSupport;
import org.simantics.db.service.SerialisationSupport;
import org.simantics.utils.ui.workbench.StringMemento;

public class ResourceTransferData
extends ArrayList<ResourceArray> {
    private static final long serialVersionUID = -6980850210973439012L;
    private SessionReference sessionReference;
    private String purpose;
    private static final String RES_KEY = "res";
    private static final String PURPOSE_KEY = "purpose";

    public ResourceTransferData() {
    }

    public ResourceTransferData(Collection<? extends ResourceArray> c) {
        super(c);
    }

    public ResourceTransferData(ResourceArray ... arrays) {
        this.addAll(arrays);
    }

    public ResourceTransferData(Session s, Collection<? extends ResourceArray> c) {
        super(c);
        LifecycleSupport lcs = (LifecycleSupport)s.getService(LifecycleSupport.class);
        this.setSessionReference(lcs.getSessionReference());
    }

    public ResourceTransferData(Session s, ResourceArray ... arrays) {
        this.addAll(arrays);
        LifecycleSupport lcs = (LifecycleSupport)s.getService(LifecycleSupport.class);
        this.setSessionReference(lcs.getSessionReference());
    }

    public ResourceTransferData(SessionReference s, Collection<? extends ResourceArray> c) {
        super(c);
        this.setSessionReference(s);
    }

    public ResourceTransferData(SessionReference s, ResourceArray ... arrays) {
        this.addAll(arrays);
        this.setSessionReference(s);
    }

    public ResourceTransferData(SessionReference s) {
        this.setSessionReference(s);
    }

    public ResourceTransferData(Session s) {
        LifecycleSupport lcs = (LifecycleSupport)s.getService(LifecycleSupport.class);
        this.setSessionReference(lcs.getSessionReference());
    }

    public SessionReference getSessionReference() {
        return this.sessionReference;
    }

    public void setSessionReference(SessionReference sessionReference) {
        this.sessionReference = sessionReference;
    }

    public String getPurpose() {
        return this.purpose;
    }

    public void setPurpose(String purpose) {
        this.purpose = purpose;
    }

    public void addAll(ResourceArray[] array) {
        ResourceArray[] resourceArrayArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            ResourceArray a = resourceArrayArray[n2];
            this.add(a);
            ++n2;
        }
    }

    public ResourceArray[] toResourceArrayArray() {
        return this.toArray(ResourceArray.NONE);
    }

    public void readFromMemento(SerialisationSupport serializer, IMemento memento) throws DatabaseException {
        String host = memento.getString("host");
        int port = memento.getInteger("port");
        int sessionIdHigh = memento.getInteger("sessionId_HIGH");
        int sessionIdLow = memento.getInteger("sessionId_LOW");
        long sessionId = (long)sessionIdLow ^ (long)sessionIdHigh << 32;
        InetSocketAddress socket = InetSocketAddress.createUnresolved(host, port);
        ProCoreServerReference ref = new ProCoreServerReference(socket);
        ProCoreSessionReference session = new ProCoreSessionReference(ref, sessionId);
        String purpose = memento.getString(PURPOSE_KEY);
        ArrayList<ResourceArray> res = new ArrayList<ResourceArray>();
        IMemento[] iMementoArray = memento.getChildren(RES_KEY);
        int n = iMementoArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMemento child = iMementoArray[n2];
            ResourceArray array = ResourceTransferData.readResourceArrayFromMemento(serializer, child);
            res.add(array);
            ++n2;
        }
        this.addAll(res);
        this.setSessionReference((SessionReference)session);
        this.setPurpose(purpose);
    }

    public static ResourceArray readResourceArrayFromMemento(SerialisationSupport serializer, IMemento memento) throws DatabaseException {
        ArrayList<Resource> result = new ArrayList<Resource>();
        int index = 0;
        while (memento.getString("" + index) != null) {
            String randomAccessId = memento.getString("" + index);
            long id = Long.parseLong(randomAccessId);
            Resource r = serializer.getResource(id);
            result.add(r);
            ++index;
        }
        return new ResourceArray(result);
    }

    public void writeToMemento(SerialisationSupport serializer, IMemento memento) throws DatabaseException {
        int index = 0;
        if (this.sessionReference != null) {
            this.writeSessionReferenceToMemento(serializer, memento);
        }
        if (this.purpose != null) {
            this.writePurpose(memento);
        }
        for (ResourceArray array : this) {
            String id = "" + index++;
            StringMemento child = (StringMemento)memento.createChild(RES_KEY, id);
            ResourceTransferData.writeResourceArrayToMemento(serializer, array, (IMemento)child);
        }
    }

    private void writePurpose(IMemento memento) {
        assert (this.purpose != null);
        memento.putString(PURPOSE_KEY, this.purpose);
    }

    public static void writeResourceArrayToMemento(SerialisationSupport serializer, ResourceArray array, IMemento sm) throws DatabaseException {
        int i = 0;
        while (i < array.resources.length) {
            Resource r = array.resources[i];
            String rai = "" + serializer.getRandomAccessId(r);
            sm.putString("" + i, rai);
            ++i;
        }
    }

    public void writeSessionReferenceToMemento(SerialisationSupport serializer, IMemento sm) {
        assert (this.sessionReference != null);
        if (!(this.sessionReference instanceof ProCoreSessionReference)) {
            throw new RuntimeException("ResourceTransferData: ProCoreSessionReference was expected as SessionReference");
        }
        ProCoreSessionReference r = (ProCoreSessionReference)this.sessionReference;
        sm.putString("host", r.serverReference.socketAddress.getHostName());
        sm.putInteger("port", r.serverReference.socketAddress.getPort());
        sm.putInteger("sessionId_LOW", (int)(r.getSessionId() & 0xFFFFFFFFFFFFFFFFL));
        sm.putInteger("sessionId_HIGH", (int)(r.getSessionId() >>> 32));
    }
}

