/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.ui.dnd;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.FlavorTable;
import java.awt.datatransfer.SystemFlavorMap;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.Policy;
import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.TransferData;
import org.simantics.ui.dnd.LocalObjectTransferable;
import sun.awt.datatransfer.DataTransferer;

public class LocalObjectTransfer
extends ByteArrayTransfer {
    public static final String TYPE_NAME = SystemFlavorMap.encodeJavaMIMEType(LocalObjectTransferable.TYPE_NAME);
    private static final int TYPEID = LocalObjectTransfer.getMapping();
    private static final LocalObjectTransfer INSTANCE = new LocalObjectTransfer();
    Object transferredObject;

    private static int getMapping() {
        for (Map.Entry<DataFlavor, String> entry : SystemFlavorMap.getDefaultFlavorMap().getNativesForFlavors(new DataFlavor[]{LocalObjectTransferable.FLAVOR}).entrySet()) {
            long[] lArray = DataTransferer.getInstance().getFormatsForFlavorAsArray(entry.getKey(), (FlavorTable)SystemFlavorMap.getDefaultFlavorMap());
            if (lArray.length == 0) continue;
            long l = lArray[0];
            return (int)l;
        }
        throw new Error("No mapping.");
    }

    protected LocalObjectTransfer() {
    }

    public static LocalObjectTransfer getTransfer() {
        return INSTANCE;
    }

    private boolean isInvalidNativeType(Object result) {
        return !(result instanceof byte[]) || !TYPE_NAME.equals(new String((byte[])result));
    }

    protected int[] getTypeIds() {
        return new int[]{TYPEID};
    }

    protected String[] getTypeNames() {
        return new String[]{TYPE_NAME};
    }

    public void javaToNative(Object object, TransferData transferData) {
        this.transferredObject = object;
        byte[] check = TYPE_NAME.getBytes();
        super.javaToNative((Object)check, transferData);
    }

    public Object nativeToJava(TransferData transferData) {
        Object result = super.nativeToJava(transferData);
        if (this.isInvalidNativeType(result)) {
            Policy.getLog().log((IStatus)new Status(4, "org.eclipse.jface", 4, JFaceResources.getString((String)"LocalObjectTransfer.errorMessage"), null));
        }
        return this.transferredObject;
    }

    public void clear() {
        this.transferredObject = null;
    }

    public Object getObject() {
        return this.transferredObject;
    }

    public void setObject(Object object) {
        this.transferredObject = object;
    }
}

