/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.ui.contribution;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.layer0.utils.collections.IContextualList;
import org.simantics.layer0.utils.operations.IOperation;
import org.simantics.project.IProject;
import org.simantics.ui.SimanticsUI;
import org.simantics.ui.contribution.DynamicMenuContribution;
import org.simantics.ui.icons.ImageUtil;
import org.simantics.ui.utils.ResourceAdaptionUtils;
import org.simantics.utils.datastructures.persistent.ContextMap;
import org.simantics.utils.datastructures.persistent.IContextMap;

public abstract class OperationsMenuContribution
extends DynamicMenuContribution {
    protected abstract Resource getListResource(ReadGraph var1) throws Exception;

    protected void assignParameters(ContextMap parameters) {
    }

    @Override
    protected IAction[] getActions(ReadGraph g, Object[] selection) {
        if (selection.length == 1) {
            final Resource r = ResourceAdaptionUtils.adaptToResource(selection[0]);
            if (r == null) {
                return new IAction[0];
            }
            try {
                return (IAction[])g.syncRequest((Read)new Read<IAction[]>(){

                    public IAction[] perform(ReadGraph g) throws DatabaseException {
                        IContextualList list;
                        try {
                            list = (IContextualList)g.adapt(OperationsMenuContribution.this.getListResource(g), IContextualList.class);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            return null;
                        }
                        final ContextMap parameters = new ContextMap();
                        parameters.put(IOperation.SUBJECT, (Object)r);
                        IProject project = SimanticsUI.peekProject();
                        if (project != null) {
                            parameters.put(IOperation.PROJECT, project.get());
                        }
                        OperationsMenuContribution.this.assignParameters(parameters);
                        ArrayList operations = new ArrayList();
                        list.fill(g, (IContextMap)parameters, operations);
                        if (!operations.isEmpty()) {
                            IAction[] actions = new IAction[operations.size()];
                            int i = 0;
                            for (Resource opRes : operations) {
                                final IOperation op = (IOperation)g.adapt(opRes, IOperation.class);
                                ImageDescriptor imgDesc = ImageUtil.adaptImageDescriptor(g, opRes);
                                final WeakReference<Session> sessionRef = new WeakReference<Session>(g.getSession());
                                actions[i++] = new Action(op.getName(), imgDesc){

                                    public void run() {
                                        Session session = (Session)sessionRef.get();
                                        if (session != null) {
                                            op.exec(session, (IContextMap)parameters);
                                        }
                                    }
                                };
                            }
                            return actions;
                        }
                        return null;
                    }
                });
            }
            catch (DatabaseException e) {
                e.printStackTrace();
            }
        }
        return null;
    }
}

