/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.ui.contribution;

import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.CompoundContributionItem;
import org.simantics.DatabaseJob;
import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.management.ISessionContext;
import org.simantics.db.request.Read;
import org.simantics.ui.SimanticsUI;
import org.simantics.utils.ui.ErrorLogger;

public abstract class DynamicMenuContribution
extends CompoundContributionItem {
    protected DynamicMenuContribution() {
    }

    protected DynamicMenuContribution(String id) {
        super(id);
    }

    protected final IContributionItem[] getContributionItems() {
        if (DatabaseJob.inProgress()) {
            return new IContributionItem[0];
        }
        ISessionContext ctx = SimanticsUI.getSessionContext();
        if (ctx != null) {
            final Object[] selection = this.getSelectedObjects();
            try {
                return (IContributionItem[])ctx.getSession().syncRequest((Read)new Read<IContributionItem[]>(){

                    public IContributionItem[] perform(ReadGraph graph) throws DatabaseException {
                        return DynamicMenuContribution.this.getContributionItems(graph, selection);
                    }
                });
            }
            catch (DatabaseException e) {
                ErrorLogger.defaultLogError((Throwable)e);
            }
        }
        return new IContributionItem[0];
    }

    public boolean isDynamic() {
        return true;
    }

    protected ISelection getSelection() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        ISelectionService service = window.getSelectionService();
        return service.getSelection();
    }

    protected Object[] getSelectedObjects() {
        ISelection sel = this.getSelection();
        if (!(sel instanceof IStructuredSelection)) {
            return new Object[0];
        }
        return ((IStructuredSelection)sel).toArray();
    }

    protected Object getSingleSelectedObject() {
        Object[] resources = this.getSelectedObjects();
        return resources.length == 1 ? resources[0] : null;
    }

    protected IContributionItem[] toContributionItems(IAction[] actions) {
        if (actions == null) {
            return new IContributionItem[0];
        }
        IContributionItem[] ret = new IContributionItem[actions.length];
        int i = 0;
        while (i < actions.length) {
            ret[i] = new ActionContributionItem(actions[i]);
            ++i;
        }
        return ret;
    }

    protected IContributionItem[] getContributionItems(ReadGraph graph, Object[] selection) throws DatabaseException {
        return this.toContributionItems(this.getActions(graph, selection));
    }

    protected IAction[] getActions(ReadGraph graph, Object[] selection) throws DatabaseException {
        return new IAction[0];
    }
}

