/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.ui.colors;

import java.awt.Color;
import org.eclipse.jface.resource.ColorDescriptor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.util.Bean;
import org.simantics.datatypes.literal.RGB;
import org.simantics.ui.colors.RGBColor;

public class Colors {
    private static double i2d(int value) {
        return (double)value / 255.0;
    }

    private static int d2i256(double value) {
        return (int)(255.9999 * value);
    }

    public static org.simantics.common.color.Color irgb(RGB rgb) {
        return new RGBColor(Colors.i2d(rgb.red), Colors.i2d(rgb.green), Colors.i2d(rgb.blue));
    }

    public static org.simantics.common.color.Color irgb(int r, int g, int b) {
        return new RGBColor(Colors.i2d(r), Colors.i2d(g), Colors.i2d(b));
    }

    public static org.simantics.common.color.Color rgb(double r, double g, double b) {
        return new RGBColor(r, g, b);
    }

    public static org.simantics.common.color.Color rgb(double[] rgb) {
        return new RGBColor(rgb[0], rgb[1], rgb[2]);
    }

    public static Color awt(org.simantics.common.color.Color color) {
        return new Color(Colors.d2i256(color.getR()), Colors.d2i256(color.getG()), Colors.d2i256(color.getB()));
    }

    public static Color awt(RGB.Integer color) {
        return new Color(color.red, color.green, color.blue);
    }

    public static org.eclipse.swt.graphics.Color swt(Device device, org.simantics.common.color.Color color) {
        return new org.eclipse.swt.graphics.Color(device, Colors.d2i256(color.getR()), Colors.d2i256(color.getG()), Colors.d2i256(color.getB()));
    }

    public static org.eclipse.swt.graphics.Color swt(Device device, org.simantics.datatypes.adt.Color color) {
        return new org.eclipse.swt.graphics.Color(device, Colors.d2i256(color.getR()), Colors.d2i256(color.getG()), Colors.d2i256(color.getB()));
    }

    public static org.eclipse.swt.graphics.Color swt(Device device, RGB.Integer color) {
        return new org.eclipse.swt.graphics.Color(device, color.red, color.green, color.blue);
    }

    public static ColorDescriptor swt(org.simantics.common.color.Color color) {
        return ColorDescriptor.createFrom((RGB)new RGB(Colors.d2i256(color.getR()), Colors.d2i256(color.getG()), Colors.d2i256(color.getB())));
    }

    public static ColorDescriptor swt(org.simantics.datatypes.adt.Color color) {
        return ColorDescriptor.createFrom((RGB)new RGB(Colors.d2i256(color.getR()), Colors.d2i256(color.getG()), Colors.d2i256(color.getB())));
    }

    public static ColorDescriptor swt(RGB.Integer color) {
        return ColorDescriptor.createFrom((RGB)new RGB(color.red, color.green, color.blue));
    }

    public static ColorDescriptor swt(Bean bean) throws BindingException {
        Integer r = (Integer)bean.getField("r", (Binding)Bindings.INTEGER);
        Integer g = (Integer)bean.getField("g", (Binding)Bindings.INTEGER);
        Integer b = (Integer)bean.getField("b", (Binding)Bindings.INTEGER);
        return ColorDescriptor.createFrom((RGB)new RGB(r.intValue(), g.intValue(), b.intValue()));
    }

    public static RGB rgb(org.simantics.common.color.Color color) {
        return new RGB(Colors.d2i256(color.getR()), Colors.d2i256(color.getG()), Colors.d2i256(color.getB()));
    }

    public static RGB.Integer integerRGB(Color awt) {
        return new RGB.Integer(awt.getRed(), awt.getGreen(), awt.getBlue());
    }
}

