/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.ui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.dynamichelpers.ExtensionTracker;
import org.eclipse.core.runtime.dynamichelpers.IExtensionChangeHandler;
import org.eclipse.core.runtime.dynamichelpers.IExtensionTracker;
import org.eclipse.core.runtime.dynamichelpers.IFilter;
import org.simantics.ui.DoubleClickExtension;
import org.simantics.ui.IDoubleClickExtension;
import org.simantics.utils.strings.StringUtils;

public class DoubleClickExtensionManager
implements IExtensionChangeHandler {
    private static final String NAMESPACE = "org.simantics.ui";
    private static final String EP_NAME = "doubleClick";
    private ExtensionTracker tracker;
    private IDoubleClickExtension[] extensions = new IDoubleClickExtension[0];
    private static DoubleClickExtensionManager INSTANCE;

    public static synchronized DoubleClickExtensionManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new DoubleClickExtensionManager();
        }
        return INSTANCE;
    }

    public static synchronized void dispose() {
        if (INSTANCE != null) {
            INSTANCE.close();
            INSTANCE = null;
        }
    }

    private DoubleClickExtensionManager() {
        this.tracker = new ExtensionTracker();
        IExtensionPoint expt = Platform.getExtensionRegistry().getExtensionPoint(NAMESPACE, EP_NAME);
        this.loadExtensions(expt.getConfigurationElements());
        IFilter filter = ExtensionTracker.createExtensionPointFilter((IExtensionPoint)expt);
        this.tracker.registerHandler((IExtensionChangeHandler)this, filter);
    }

    private void close() {
        this.tracker.close();
        this.tracker = null;
        this.extensions = new IDoubleClickExtension[0];
    }

    public IDoubleClickExtension[] getExtensions() {
        return this.extensions;
    }

    private void loadExtensions(IConfigurationElement[] elements) {
        HashSet<IDoubleClickExtension> newExtensions = new HashSet<IDoubleClickExtension>(Arrays.asList(this.extensions));
        IConfigurationElement[] iConfigurationElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement el = iConfigurationElementArray[n2];
            String name = StringUtils.safeString((String)el.getAttribute("name"));
            double priority = 0.0;
            try {
                String p = el.getAttribute("priority");
                if (p != null) {
                    priority = Double.parseDouble(p);
                }
            }
            catch (NumberFormatException p) {
                // empty catch block
            }
            DoubleClickExtension ext = new DoubleClickExtension(el, name, priority);
            this.tracker.registerObject(el.getDeclaringExtension(), (Object)ext, 0);
            newExtensions.add(ext);
            ++n2;
        }
        ArrayList<IDoubleClickExtension> unsorted = new ArrayList<IDoubleClickExtension>(newExtensions);
        Collections.sort(unsorted, new Comparator<IDoubleClickExtension>(){

            @Override
            public int compare(IDoubleClickExtension o1, IDoubleClickExtension o2) {
                return Double.compare(o2.getPriority(), o1.getPriority());
            }
        });
        this.extensions = unsorted.toArray(new IDoubleClickExtension[unsorted.size()]);
    }

    public void addExtension(IExtensionTracker tracker, IExtension extension) {
        this.loadExtensions(extension.getConfigurationElements());
    }

    public void removeExtension(IExtension extension, Object[] objects) {
        HashSet<IDoubleClickExtension> newExtensions = new HashSet<IDoubleClickExtension>(Arrays.asList(this.extensions));
        Object[] objectArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            this.tracker.unregisterObject(extension, o);
            newExtensions.remove(o);
            ++n2;
        }
        this.extensions = newExtensions.toArray(new IDoubleClickExtension[newExtensions.size()]);
    }
}

