/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.spreadsheet.util;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.simantics.Simantics;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.binding.mutable.MutableVariant;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.exception.VariableException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.VariableSpaceManipulator;
import org.simantics.db.request.Write;
import org.simantics.db.request.WriteInterface;
import org.simantics.db.service.SerialisationSupport;
import org.simantics.layer0.Layer0;
import org.simantics.scl.runtime.tuple.Tuple;
import org.simantics.spreadsheet.CellEditor;
import org.simantics.spreadsheet.ClientModel;
import org.simantics.spreadsheet.Range;
import org.simantics.spreadsheet.common.cell.StringCellParser;
import org.simantics.spreadsheet.common.exception.CellParseException;
import org.simantics.spreadsheet.resource.SpreadsheetResource;
import org.simantics.utils.datastructures.Pair;

public class SpreadsheetUtils {
    private static Charset ISO = Charset.forName("ISO-8859-1");

    public static String offset(String location, int rowOffset, int columnOffset) {
        Range range = SpreadsheetUtils.decodeCellAbsolute(location);
        String result = SpreadsheetUtils.cellName(range.startRow + rowOffset, range.startColumn + columnOffset);
        return result;
    }

    public static Object extract(Object object, int row, int column) {
        if (object instanceof List) {
            List list = (List)object;
            if (list.size() <= row) {
                return null;
            }
            Object item = list.get(row);
            if (item instanceof Tuple) {
                Tuple tuple = (Tuple)item;
                if (tuple.length() <= column) {
                    return null;
                }
                return tuple.get(column);
            }
        }
        return null;
    }

    public static String columnName(int column, int current, int limit, int chars) {
        if (column < limit) {
            char[] buf = new char[chars];
            column -= current;
            int i = chars - 1;
            while (i >= 0) {
                char rem = (char)(column % 26);
                column /= 26;
                buf[i] = (char)(65 + rem);
                --i;
            }
            return new String(buf);
        }
        return SpreadsheetUtils.columnName(column, limit, 26 * (limit + 1), chars + 1);
    }

    public static String columnName(int column) {
        return SpreadsheetUtils.columnName(column, 0, 26, 1);
    }

    public static String cellName(int row, int column) {
        String result = SpreadsheetUtils.columnName(column);
        result = String.valueOf(result) + (row + 1);
        return result;
    }

    public static Range decodeCellAbsolute(String identifier) {
        long l = SpreadsheetUtils.decodeCellCoded(identifier);
        int row = (int)(l & 0xFFFFFFFFFFFFFFFFL);
        int column = (int)(l >> 32 & 0xFFFFFFFFFFFFFFFFL);
        return new Range(row, row, column, column);
    }

    public static Range decodePossibleCellAbsolute(String identifier) {
        try {
            return SpreadsheetUtils.decodeCellAbsolute(identifier);
        }
        catch (CellParseException e) {
            return null;
        }
    }

    public static long decodeCellCoded(String identifier) {
        char b;
        int row = 0;
        int column = 0;
        int position = 0;
        int length = identifier.length();
        while (position < length) {
            b = identifier.charAt(position);
            if (b < 'A' || b > 'Z') break;
            column = column * 26 + (b - 65 + 1);
            ++position;
        }
        while (position < length) {
            b = identifier.charAt(position);
            if (b < '0' || b > '9') break;
            row = row * 10 + b - 48;
            ++position;
        }
        if (position == length) {
            return (long)(--row) + ((long)(--column) << 32);
        }
        throw new CellParseException("Cell identifier '" + identifier + "' is not a valid cell reference.");
    }

    public static Range decodeCellRelative(String identifier, int row, int column) {
        int offset = Integer.valueOf(identifier.substring(1).trim());
        if (identifier.startsWith("L") || identifier.startsWith("l")) {
            return new Range(row, row, column - offset, column - offset);
        }
        if (identifier.startsWith("R") || identifier.startsWith("r")) {
            return new Range(row, row, column + offset, column + offset);
        }
        if (identifier.startsWith("U") || identifier.startsWith("u")) {
            return new Range(row - offset, row - offset, column, column);
        }
        if (identifier.startsWith("D") || identifier.startsWith("d")) {
            return new Range(row + offset, row + offset, column, column);
        }
        throw new CellParseException("Relative cell syntax must begin with L|R|U|D.");
    }

    public static Range decodeCell(String identifier, int row, int column) {
        if (identifier.startsWith("_")) {
            return SpreadsheetUtils.decodeCellRelative(identifier.substring(1), row, column);
        }
        return SpreadsheetUtils.decodeCellAbsolute(identifier);
    }

    public static Range decodeReference(String identifier, int row, int column) {
        if (!identifier.startsWith("&")) {
            throw new CellParseException("A reference cell was expected.");
        }
        return SpreadsheetUtils.decodeRange(identifier.substring(1), row, column);
    }

    public static Range decodeRange(String rangeOrCell) {
        return SpreadsheetUtils.decodeRange(rangeOrCell, 0, 0);
    }

    public static Range decodeRange(String rangeOrCell, int row, int column) {
        String[] parts = rangeOrCell.split(":");
        if (parts.length == 1) {
            return SpreadsheetUtils.decodeCell(rangeOrCell, row, column);
        }
        if (parts.length == 2) {
            Range from = SpreadsheetUtils.decodeCell(parts[0].trim(), row, column);
            Range to = SpreadsheetUtils.decodeCell(parts[1].trim(), row, column);
            return Range.combine((Range)from, (Range)to);
        }
        throw new CellParseException("The reference cell syntax was invalid. At most 1 occurrence of ':' is expected.");
    }

    public static Pair<String, Collection<VariableSpaceManipulator.PropertyCreationData>> parse(String text, StringCellParser[] parsers) {
        try {
            StringCellParser[] stringCellParserArray = parsers;
            int n = parsers.length;
            int n2 = 0;
            while (n2 < n) {
                StringCellParser parser = stringCellParserArray[n2];
                Collection<VariableSpaceManipulator.PropertyCreationData> parsed = parser.parse(text);
                if (parsed != null) {
                    return Pair.make((Object)parser.getType(), parsed);
                }
                ++n2;
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return null;
    }

    public static boolean isImmutable(Object object) {
        return !(object instanceof Resource) && !(object instanceof Variable);
    }

    public static String getLabel(ReadGraph graph, Object object) throws DatabaseException {
        if (object == null) {
            return "no data";
        }
        if (object instanceof Resource) {
            return NameUtils.getSafeName((ReadGraph)graph, (Resource)((Resource)object));
        }
        if (object instanceof Variable) {
            try {
                Object value = ((Variable)object).getValue(graph);
                return value.toString();
            }
            catch (VariableException e) {
                Object value = ((Variable)object).getPropertyValue(graph, "Label");
                return value.toString();
            }
        }
        if (object instanceof double[]) {
            return object.toString();
        }
        return object.toString();
    }

    private static String toString(Object object) {
        if (object instanceof double[]) {
            try {
                return Bindings.DOUBLE_ARRAY.toString(object);
            }
            catch (BindingException e) {
                return object.toString();
            }
        }
        return object.toString();
    }

    public static String getContent(ReadGraph graph, Object object) throws DatabaseException {
        if (object == null) {
            return null;
        }
        if (object instanceof Resource) {
            SerialisationSupport support = (SerialisationSupport)graph.getService(SerialisationSupport.class);
            return support.getResourceSerializer().createRandomAccessId((Resource)object);
        }
        if (object instanceof Variable) {
            return ((Variable)object).getURI(graph);
        }
        return "";
    }

    public static void main(String[] args) {
        int i = 0;
        while (i < 16384) {
            String name = SpreadsheetUtils.columnName(i);
            Range r = SpreadsheetUtils.decodeCellAbsolute(String.valueOf(name) + "1");
            System.err.println(String.valueOf(i) + " " + name + " " + r);
            ++i;
        }
    }

    public static String getLabel(ClientModel model, int row, int column) {
        try {
            String location = SpreadsheetUtils.cellName(row, column);
            String label = (String)model.getPropertyAt(location, "label");
            if (label != null) {
                return label;
            }
            Variant content = SpreadsheetUtils.getSafeClientVariant(model, location, "content");
            if (content != null) {
                return SpreadsheetUtils.getContentString(content);
            }
            return null;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getContentString(Variant content) {
        return content.getValue().toString();
    }

    public static boolean isInBounds(String base, String location, int wBounds, int hBounds) {
        int hb;
        Range baseRange = SpreadsheetUtils.decodeCellAbsolute(base);
        Range locationRange = SpreadsheetUtils.decodeCellAbsolute(location);
        if (locationRange.startColumn < baseRange.startColumn) {
            return false;
        }
        if (locationRange.startRow < baseRange.startRow) {
            return false;
        }
        int wb = wBounds == -1 ? 0x2AAAAAAA : wBounds;
        int n = hb = hBounds == -1 ? 0x2AAAAAAA : hBounds;
        if (locationRange.startColumn > baseRange.startColumn + wb - 1) {
            return false;
        }
        return locationRange.startRow <= baseRange.startRow + hb - 1;
    }

    public static void schedule(CellEditor.Transaction transaction, Write write) {
        if (transaction == null) {
            TransactionImpl impl = (TransactionImpl)SpreadsheetUtils.startTransaction();
            impl.add(write);
            impl.commit();
        } else {
            TransactionImpl impl = (TransactionImpl)transaction;
            impl.add(write);
        }
    }

    public static CellEditor.Transaction startTransaction() {
        return new TransactionImpl();
    }

    public static MutableVariant createVariant() {
        return new MutableVariant();
    }

    public static Variant getSafeClientVariant(ClientModel clientModel, String location, String property) {
        try {
            return (Variant)clientModel.getPossiblePropertyAt(location, property);
        }
        catch (Throwable t) {
            Logger.defaultLogError((Throwable)t);
            return Variant.ofInstance((Object)t.getMessage());
        }
    }

    public static Resource createSheet(WriteGraph graph, Resource book, String name, String[] colNames, int[] colWidths) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        SpreadsheetResource sr = SpreadsheetResource.getInstance((ReadGraph)graph);
        Resource result = graph.newResource();
        graph.claim(result, L0.InstanceOf, null, sr.Spreadsheet);
        if (name == null) {
            name = NameUtils.findFreshEscapedName((ReadGraph)graph, (String)"Sheet", (Resource)book, (Resource)L0.ConsistsOf);
        }
        graph.claimLiteral(result, L0.HasName, L0.NameOf, L0.String, (Object)name, (Binding)Bindings.STRING);
        graph.claim(book, L0.ConsistsOf, L0.PartOf, result);
        Resource newCell = graph.newResource();
        graph.claim(newCell, L0.InstanceOf, null, sr.Dimensions);
        graph.claimLiteral(newCell, L0.HasName, L0.NameOf, L0.String, (Object)"Dimensions", (Binding)Bindings.STRING);
        graph.addLiteral(newCell, sr.Dimensions_fitColumns, sr.Dimensions_fitColumns_Inverse, L0.Boolean, (Object)false, (Binding)Bindings.BOOLEAN);
        graph.addLiteral(newCell, sr.Dimensions_fitRows, sr.Dimensions_fitRows_Inverse, L0.Boolean, (Object)false, (Binding)Bindings.BOOLEAN);
        graph.addLiteral(newCell, sr.Dimensions_columnCount, sr.Dimensions_columnCount_Inverse, L0.Integer, (Object)128, (Binding)Bindings.INTEGER);
        graph.addLiteral(newCell, sr.Dimensions_rowCount, sr.Dimensions_rowCount_Inverse, L0.Integer, (Object)256, (Binding)Bindings.INTEGER);
        graph.claim(result, L0.ConsistsOf, L0.PartOf, newCell);
        newCell = graph.newResource();
        graph.claim(newCell, L0.InstanceOf, null, sr.Headers);
        graph.claimLiteral(newCell, L0.HasName, L0.NameOf, L0.String, (Object)"Headers", (Binding)Bindings.STRING);
        graph.addLiteral(newCell, sr.Headers_columnLabels, sr.Headers_columnLabels_Inverse, L0.StringArray, (Object)colNames, (Binding)Bindings.STRING_ARRAY);
        graph.addLiteral(newCell, sr.Headers_columnWidths, sr.Headers_columnWidths_Inverse, L0.IntegerArray, (Object)colWidths, (Binding)Bindings.INT_ARRAY);
        graph.claim(result, L0.ConsistsOf, L0.PartOf, newCell);
        return result;
    }

    static class TransactionImpl
    implements CellEditor.Transaction {
        private ArrayList<Write> writes = new ArrayList();

        TransactionImpl() {
        }

        public void commit() {
            Simantics.async((WriteInterface)new WriteRequest(){

                public void perform(WriteGraph graph) throws DatabaseException {
                    graph.markUndoPoint();
                    int i = 0;
                    while (i < TransactionImpl.this.writes.size()) {
                        Write write = (Write)TransactionImpl.this.writes.get(i);
                        graph.syncRequest(write);
                        ++i;
                    }
                    TransactionImpl.this.writes.clear();
                }
            });
        }

        public void add(Write write) {
            this.writes.add(write);
        }
    }
}

