/*
 * Decompiled with CFR 0.152.
 */
package fi.semantum.sysdyn.solver;

import fi.semantum.sysdyn.solver.Array;
import fi.semantum.sysdyn.solver.Constant;
import fi.semantum.sysdyn.solver.Environment;
import fi.semantum.sysdyn.solver.IEnvironment;
import fi.semantum.sysdyn.solver.IExpression;
import fi.semantum.sysdyn.solver.SolverUtils;
import fi.semantum.sysdyn.solver.UnassignedVariableException;
import fi.semantum.sysdyn.solver.Utils;
import fi.semantum.sysdyn.solver.Variable;

public class VariableBase {
    static final int[] UNINIT = new int[0];
    public String name;
    public int index;
    public int[] dimensions = UNINIT;

    public VariableBase(String name) {
        this.name = name;
    }

    public VariableBase(String name, int index) {
        this.name = name;
        this.index = index;
    }

    public VariableBase(String name, int index, int[] dimensions) {
        this.name = name;
        this.index = index;
        this.dimensions = dimensions;
    }

    public boolean tellSubscripts(IExpression[] e, IExpression modification) {
        if (this.dimensions != UNINIT) {
            return true;
        }
        if (e != null) {
            if (this.dimensions == UNINIT) {
                this.dimensions = new int[e.length];
            }
            if (e.length == 0) {
                throw new IllegalStateException();
            }
            int i = 0;
            while (i < e.length) {
                IExpression exp = e[i];
                Object constant = exp.getPossibleConstant();
                if (constant != null) {
                    exp = (IExpression)constant;
                }
                if (!(exp instanceof Constant)) {
                    this.dimensions[i] = -1;
                } else {
                    Constant c = (Constant)exp;
                    int index = ((Double)c.value).intValue();
                    if (index == -1) {
                        if (modification instanceof Array) {
                            Array array = (Array)modification;
                            this.dimensions[i] = array.size(i);
                        } else {
                            this.dimensions[i] = -1;
                        }
                    } else if (index > this.dimensions[i]) {
                        this.dimensions[i] = index;
                    }
                }
                ++i;
            }
        } else {
            this.dimensions = null;
        }
        return this.dimensions != UNINIT;
    }

    public int dimension() {
        if (this.dimensions == null) {
            return 1;
        }
        int result = 1;
        int[] nArray = this.dimensions;
        int n = this.dimensions.length;
        int n2 = 0;
        while (n2 < n) {
            int d = nArray[n2];
            result *= d;
            ++n2;
        }
        return result;
    }

    public boolean isStoredAsArray() {
        if (this.dimensions == null) {
            return false;
        }
        int[] nArray = this.dimensions;
        int n = this.dimensions.length;
        int n2 = 0;
        while (n2 < n) {
            int d = nArray[n2];
            if (d == -1) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    VariableBase withBase(String prefix) {
        return new VariableBase(String.valueOf(prefix) + this.name, this.index, this.dimensions);
    }

    private int makeSubscriptIndex(IEnvironment env, IExpression[] subscripts) {
        if (this.dimensions == null) {
            return 0;
        }
        int result = 0;
        int i = 0;
        while (i < subscripts.length) {
            int factor = 1;
            int j = i + 1;
            while (j < subscripts.length) {
                factor *= this.dimensions[j];
                ++j;
            }
            IExpression e = subscripts[i];
            Double v = (Double)e.evaluate(env);
            int index = v.intValue() - 1;
            if (index == -2) {
                return 0;
            }
            result += factor * index;
            ++i;
        }
        if (result == -1) {
            throw new IllegalStateException();
        }
        return result;
    }

    public int subscriptIndex(IEnvironment env, IExpression[] subscripts) {
        if (subscripts == null) {
            return 0;
        }
        return this.makeSubscriptIndex(env, subscripts);
    }

    public int index(IEnvironment env, IExpression[] subscripts) {
        return this.index + this.subscriptIndex(env, subscripts);
    }

    public Object getArrayIndex(IEnvironment environment, IExpression[] subscripts, Array array) {
        Object result = array;
        IExpression[] iExpressionArray = subscripts;
        int n = subscripts.length;
        int n2 = 0;
        while (n2 < n) {
            IExpression e = iExpressionArray[n2];
            int index = Utils.getIndex(e.evaluate(environment));
            result = ((Array)result).element(index);
            ++n2;
        }
        if (result instanceof IExpression) {
            IExpression exp = (IExpression)result;
            return exp.evaluate(environment);
        }
        if (result instanceof Array) {
            throw new IllegalStateException();
        }
        return result;
    }

    private boolean hasScalarSubscript(IExpression[] subscripts) {
        return subscripts != null;
    }

    public int intoArray(IEnvironment env, int index, int d, Array target) {
        if (d == this.dimensions.length - 1) {
            int i = 0;
            while (i < this.dimensions[d]) {
                Object value = env.getValue(index);
                if (value == null) {
                    throw new UnassignedVariableException("No value for " + this.name);
                }
                target.addElement(value);
                ++index;
                ++i;
            }
            return index;
        }
        int i = 0;
        while (i < this.dimensions[d]) {
            Array array = new Array();
            index = this.intoArray(env, index, d + 1, array);
            target.addElement(array);
            ++i;
        }
        return index;
    }

    public int getConstantIndex(IEnvironment environment, IExpression[] subscripts) {
        if (this.isStoredAsArray()) {
            return -1;
        }
        if (this.dimension() > 1) {
            Array[] sub;
            if (subscripts != null && !SolverUtils.isSlice(sub = SolverUtils.parseSubscripts(environment, subscripts)) && this.areSubscriptsConstant(subscripts)) {
                return this.index(environment, subscripts);
            }
            return -1;
        }
        Object result = environment.getNamedValue(this.name);
        if (result != null) {
            return -1;
        }
        if (!this.areSubscriptsConstant(subscripts)) {
            return -1;
        }
        return this.index(environment, subscripts);
    }

    boolean areSubscriptsConstant(IExpression[] subscripts) {
        if (subscripts == null) {
            return true;
        }
        IExpression[] iExpressionArray = subscripts;
        int n = subscripts.length;
        int n2 = 0;
        while (n2 < n) {
            IExpression e = iExpressionArray[n2];
            if (!(e instanceof Constant)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public Object evaluate(IEnvironment environment, IExpression[] subscripts, int constantIndex) {
        if (constantIndex >= 0 && environment instanceof Environment) {
            Double result = (Double)environment.getValue(constantIndex);
            if (result == null) {
                throw new UnassignedVariableException("No value for " + this.name);
            }
            if (SolverUtils.isArray(this.dimensions) && subscripts == null) {
                return new Array().addElement(result);
            }
            return result;
        }
        if (this.isStoredAsArray()) {
            Array array = (Array)environment.getValue(this.index);
            if (this.hasScalarSubscript(subscripts)) {
                Object o = this.getArrayIndex(environment, subscripts, array);
                if (o instanceof Variable) {
                    throw new IllegalStateException();
                }
                if (o instanceof Array) {
                    throw new IllegalStateException();
                }
                return o;
            }
            return array;
        }
        if (this.dimension() > 1) {
            if (subscripts != null) {
                Array[] sub = SolverUtils.parseSubscripts(environment, subscripts);
                if (SolverUtils.isSlice(sub)) {
                    Array arr = new Array();
                    this.intoArray(environment, this.index, 0, arr);
                    return arr.slice(sub);
                }
                return environment.getValue(this.index(environment, subscripts));
            }
            Array array = new Array();
            this.intoArray(environment, this.index, 0, array);
            return array;
        }
        Object result = environment.getNamedValue(this.name);
        if (result == null) {
            result = environment.getValue(this.index(environment, subscripts));
        }
        if (result == null) {
            throw new UnassignedVariableException("No value for " + this.name);
        }
        if (SolverUtils.isArray(this.dimensions) && subscripts == null) {
            return new Array().addElement(result);
        }
        return result;
    }

    public IExpression getPossibleConstant() {
        return null;
    }
}

