/*
 * Decompiled with CFR 0.152.
 */
package fi.semantum.sysdyn.solver;

import fi.semantum.sysdyn.solver.Argument;
import fi.semantum.sysdyn.solver.Array;
import fi.semantum.sysdyn.solver.Assignment;
import fi.semantum.sysdyn.solver.Constant;
import fi.semantum.sysdyn.solver.Environment;
import fi.semantum.sysdyn.solver.Fn;
import fi.semantum.sysdyn.solver.Function;
import fi.semantum.sysdyn.solver.IExpression;
import fi.semantum.sysdyn.solver.Model;
import fi.semantum.sysdyn.solver.NodeCache;
import fi.semantum.sysdyn.solver.ParameterDeclaration;
import fi.semantum.sysdyn.solver.Parser;
import fi.semantum.sysdyn.solver.Variable;
import fi.semantum.sysdyn.solver.VariableBase;
import fi.semantum.sysdyn.solver.VariableDeclaration;
import fi.semantum.sysdyn.solver.parser.ModelParser;
import fi.semantum.sysdyn.solver.parser.SimpleNode;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import org.simantics.utils.datastructures.MapList;

public class Solver {
    private static final boolean PRINT_EXCEPTIONS = false;
    private static final int STACK_SIZE = 1000;
    private Model model;
    private Environment env;
    private Object[] newValues;
    private Object[] derivatives;
    private double defaultStep = 0.1;
    private double start = 0.0;
    private NodeCache cache = new NodeCache();
    private boolean ready = false;
    private boolean dirty;
    private boolean started;
    private SimpleNode n;
    private String codeCache = null;

    public void setStep(double step) {
        this.defaultStep = step;
        if (this.env != null) {
            this.env.step = step;
        }
    }

    public void setStart(double start) {
        this.start = start;
        this.ready = false;
    }

    private void sortAssignments() {
        final MapList asses = new MapList();
        for (Assignment ass : this.model.assignments) {
            asses.add((Object)ass.target.base.name, (Object)ass);
        }
        final ArrayList found = new ArrayList();
        final HashSet visited = new HashSet();
        IExpression.ExpressionVisitor sortVisitor = new IExpression.ExpressionVisitor(){

            @Override
            public void visit(IExpression expression) {
                if (expression instanceof Variable) {
                    Variable var = (Variable)expression;
                    if (visited.add(var.base.name)) {
                        for (Assignment ass : asses.getValues((Object)var.base.name)) {
                            ass.expression.accept(this);
                            if (ass.subscripts == null) continue;
                            IExpression[] iExpressionArray = ass.subscripts;
                            int n = ass.subscripts.length;
                            int n2 = 0;
                            while (n2 < n) {
                                IExpression e = iExpressionArray[n2];
                                e.accept(this);
                                ++n2;
                            }
                        }
                        found.add(var.base);
                    }
                }
            }
        };
        for (Assignment ass : this.model.assignments) {
            ass.target.accept(sortVisitor);
        }
        Collections.sort(this.model.assignments, new Comparator<Assignment>(){

            @Override
            public int compare(Assignment o1, Assignment o2) {
                int i2;
                int i1 = found.indexOf(o1.target.base);
                if (i1 < (i2 = found.indexOf(o2.target.base))) {
                    return -1;
                }
                if (i1 > i2) {
                    return 1;
                }
                return 0;
            }
        });
    }

    public void prepare(String input) throws Exception {
        long startNanos = System.nanoTime();
        if (!input.equals(this.codeCache)) {
            StringReader reader = new StringReader(input);
            ModelParser modelParser = new ModelParser(reader);
            this.n = (SimpleNode)modelParser.stored_definition();
        }
        Parser parser = new Parser();
        this.model = new Model(new Model.Globals(), "", false);
        parser.walk(this.n, 0, this.model);
        this.codeCache = input;
        this.env = new Environment(this.model, this.defaultStep, this.start);
        int size = this.model.prepare();
        this.env.setSize(size);
        for (Fn fn : this.model.functions.values()) {
            if (!(fn instanceof Function)) continue;
            ((Function)fn).prepare();
        }
        this.env.valueTable = new Object[size + 1000];
        this.sortAssignments();
        this.model.assignmentArray = this.model.assignments.toArray(new Assignment[this.model.assignments.size()]);
        this.model.derivativeArray = this.model.derivatives.toArray(new Assignment[this.model.derivatives.size()]);
        this.model.parameterArray = this.model.parameters.toArray(new ParameterDeclaration[this.model.parameters.size()]);
        this.newValues = new Object[Math.max(this.model.assignments.size(), this.model.derivatives.size())];
        this.derivatives = new Object[this.model.derivatives.size()];
        int condition = 1;
        int loops = 0;
        while (condition > 0 && loops++ < 50) {
            condition = 0;
            for (ParameterDeclaration pd : this.model.parameters) {
                try {
                    if (pd.assigned) continue;
                    pd.variable.assign(this.env, null, pd.modification.evaluate(this.env));
                    pd.assigned = true;
                }
                catch (Exception e) {
                    ++condition;
                }
            }
            ArrayList<Assignment> assignments = new ArrayList<Assignment>();
            assignments.addAll(this.model.assignments);
            assignments.addAll(this.model.initials);
            for (VariableDeclaration vd : this.model.variables) {
                try {
                    if (vd.assigned) continue;
                    Argument[] argumentArray = vd.modification.args;
                    int n = vd.modification.args.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Argument arg = argumentArray[n2];
                        if (arg.name.endsWith("start")) {
                            Object value = arg.modification.evaluate(this.env);
                            if (vd.variable.base.dimension() == 1) {
                                vd.variable.assign(this.env, null, value);
                            } else if (value instanceof Double) {
                                Array array = new Array();
                                int i = 0;
                                while (i < vd.variable.base.dimension()) {
                                    array.addElement(value);
                                    ++i;
                                }
                                vd.variable.assign(this.env, null, array);
                            } else {
                                throw new IllegalStateException();
                            }
                            for (Assignment a : assignments) {
                                if (!vd.variable.base.equals(a.target.base)) continue;
                                a.assigned = true;
                            }
                        }
                        ++n2;
                    }
                }
                catch (Exception e) {
                    ++condition;
                }
            }
            for (Assignment ass : assignments) {
                try {
                    Object value;
                    if (ass.assigned || (value = ass.expression.evaluate(this.env)) == null) continue;
                    ass.target.assign(this.env, ass.subscripts, value);
                    ass.assigned = true;
                }
                catch (Exception e) {
                    ++condition;
                }
            }
        }
        for (Assignment ass : this.model.assignments) {
            if (!(ass.expression instanceof Constant)) continue;
            ass.isConstant = true;
        }
        this.env.initial = false;
        this.ready = true;
        this.started = false;
        this.dirty = false;
        long endNanos = System.nanoTime();
    }

    public String[] keys() {
        return this.env.getValueKeyArray();
    }

    public double[] values() {
        return this.env.getValueArray();
    }

    public void aboutToRun() {
        if (!this.started && this.dirty) {
            Assignment[] assignments = this.model.assignmentArray;
            int i = 0;
            while (i < assignments.length) {
                if (!assignments[i].isConstant) {
                    Object value = assignments[i].expression.evaluate(this.env);
                    assignments[i].target.assign(this.env, assignments[i].subscripts, value);
                }
                ++i;
            }
            for (Assignment ass : this.model.initials) {
                if (ass.isConstant) continue;
                Object value = ass.expression.evaluate(this.env);
                ass.target.assign(this.env, ass.subscripts, value);
            }
            for (VariableDeclaration vd : this.model.variables) {
                try {
                    Argument[] argumentArray = vd.modification.args;
                    int n = vd.modification.args.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Argument arg = argumentArray[n2];
                        if (arg.name.endsWith("start")) {
                            Object value = arg.modification.evaluate(this.env);
                            if (vd.variable.base.dimension() == 1) {
                                vd.variable.assign(this.env, null, value);
                            } else if (value instanceof Double) {
                                Array array = new Array();
                                int i2 = 0;
                                while (i2 < vd.variable.base.dimension()) {
                                    array.addElement(value);
                                    ++i2;
                                }
                                vd.variable.assign(this.env, null, array);
                            } else {
                                throw new IllegalStateException();
                            }
                        }
                        ++n2;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.dirty = false;
        }
    }

    public void step() {
        if (!this.ready) {
            return;
        }
        this.started = true;
        Assignment[] assignments = this.model.assignmentArray;
        Assignment[] derivatives = this.model.derivativeArray;
        int i = 0;
        while (i < this.model.derivatives.size()) {
            this.newValues[i] = derivatives[i].expression.evaluate(this.env);
            ++i;
        }
        i = 0;
        while (i < this.model.derivatives.size()) {
            derivatives[i].target.assign(this.env, derivatives[i].subscripts, this.newValues[i]);
            ++i;
        }
        this.env.time += this.env.step;
        VariableBase base = this.model.names.get("time");
        if (base != null) {
            this.env.put(base.index, (Object)this.env.time);
        }
        int i2 = 0;
        while (i2 < assignments.length) {
            if (!assignments[i2].isConstant) {
                Object value = assignments[i2].expression.evaluate(this.env);
                assignments[i2].target.assign(this.env, assignments[i2].subscripts, value);
            }
            ++i2;
        }
    }

    public void printEnvironment() {
        String[] keys = this.keys();
        double[] values = this.values();
        System.err.println("Environment " + keys.length + " " + values.length);
        int i = 0;
        while (i < keys.length) {
            System.err.println(String.valueOf(keys[i]) + " = " + values[i]);
            ++i;
        }
    }

    public double getTime() {
        return this.env.time;
    }

    public void setValue(String key, double value) {
        this.env.setValue(key, value);
        this.dirty = true;
    }
}

