/*
 * Decompiled with CFR 0.152.
 */
package fi.semantum.sysdyn.solver;

import fi.semantum.sysdyn.solver.Fn;
import fi.semantum.sysdyn.solver.ForIndex;
import fi.semantum.sysdyn.solver.IEnvironment;
import fi.semantum.sysdyn.solver.IFrame;
import fi.semantum.sysdyn.solver.IStatement;
import fi.semantum.sysdyn.solver.Model;
import fi.semantum.sysdyn.solver.Variable;
import fi.semantum.sysdyn.solver.VariableBase;
import fi.semantum.sysdyn.solver.VariableDeclaration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public final class Function
implements Fn,
IFrame {
    public static final boolean PRINT = false;
    public final String name;
    public final IStatement statement;
    public ArrayList<VariableDeclaration> inputs = new ArrayList();
    public ArrayList<VariableDeclaration> outputs = new ArrayList();
    public ArrayList<VariableDeclaration> internals = new ArrayList();
    public Variable[] parameters;
    public ArrayList<ForIndex> indices = new ArrayList();
    public HashMap<String, VariableBase> names = new HashMap();

    public Function(String name, IStatement statement) {
        this.name = name;
        this.statement = statement;
    }

    @Override
    public Object evaluate(IEnvironment environment, int argc) {
        this.statement.evaluate(environment);
        VariableDeclaration out = this.outputs.get(0);
        return environment.getValue(out.variable.base.index);
    }

    @Override
    public void setLocals(IEnvironment environment) {
        VariableDeclaration decl;
        int i = 0;
        while (i < this.outputs.size()) {
            decl = this.outputs.get(i);
            decl.variable.assignPlain(environment, null);
            ++i;
        }
        i = 0;
        while (i < this.internals.size()) {
            decl = this.internals.get(i);
            decl.variable.assignPlain(environment, null);
            ++i;
        }
    }

    public VariableBase addIndex(String name, ForIndex index) {
        this.indices.add(index);
        return this.getBase(name);
    }

    @Override
    public VariableBase getBase(String name) {
        VariableBase base = this.names.get(name);
        if (base == null) {
            base = new VariableBase(name);
            this.names.put(name, base);
        }
        return base;
    }

    @Override
    public VariableBase getBase(VariableBase base, String prefix) {
        throw new IllegalStateException();
    }

    public void prepare() {
        VariableDeclaration decl;
        int nextIndex = 0;
        for (Map.Entry<String, VariableBase> entry : this.names.entrySet()) {
            VariableBase base = entry.getValue();
            base.index = nextIndex;
            nextIndex += base.dimension();
        }
        this.parameters = new Variable[this.inputs.size()];
        int i = 0;
        while (i < this.inputs.size()) {
            decl = this.inputs.get(i);
            this.parameters[i] = decl.variable;
            decl.variable.base.tellSubscripts(decl.variable.subscripts, null);
            ++i;
        }
        i = 0;
        while (i < this.outputs.size()) {
            decl = this.outputs.get(i);
            decl.variable.base.tellSubscripts(decl.variable.subscripts, null);
            ++i;
        }
        i = 0;
        while (i < this.internals.size()) {
            decl = this.internals.get(i);
            decl.variable.base.tellSubscripts(decl.variable.subscripts, null);
            ++i;
        }
    }

    @Override
    public int offset() {
        return this.names.size();
    }

    @Override
    public Variable[] parameters() {
        return this.parameters;
    }

    @Override
    public Object evaluateInput(IEnvironment environment, int argPosition) {
        VariableDeclaration decl = this.inputs.get(argPosition);
        return decl.modification.args[0].modification.evaluate(environment);
    }

    @Override
    public Model getClass(String name) {
        return null;
    }
}

