/*
 * Decompiled with CFR 0.152.
 */
package fi.semantum.sysdyn.solver;

import fi.semantum.sysdyn.solver.Array;
import fi.semantum.sysdyn.solver.ForIndex;
import fi.semantum.sysdyn.solver.IEnvironment;
import fi.semantum.sysdyn.solver.IStatement;
import java.util.ArrayList;

public class ForStatement
implements IStatement {
    public ArrayList<ForIndex> indices;
    public IStatement statement;

    public ForStatement(ArrayList<ForIndex> indices, IStatement statement) {
        this.indices = indices;
        this.statement = statement;
    }

    public String toString() {
        return "for " + this.indices + " loop " + this.statement + " end for";
    }

    private void loop(IEnvironment environment, int i) {
        if (i == this.indices.size()) {
            this.statement.evaluate(environment);
            return;
        }
        ForIndex index = this.indices.get(i);
        Array array = (Array)index.expression.evaluate(environment);
        for (Object element : array.elements()) {
            environment.put(index.base.index, element);
            this.loop(environment, i + 1);
        }
    }

    @Override
    public void evaluate(IEnvironment environment) {
        this.loop(environment, 0);
    }
}

