/*
 * Decompiled with CFR 0.152.
 */
package fi.semantum.sysdyn.solver;

import fi.semantum.sysdyn.solver.Array;
import fi.semantum.sysdyn.solver.IEnvironment;
import fi.semantum.sysdyn.solver.IExpression;
import fi.semantum.sysdyn.solver.IFrame;
import fi.semantum.sysdyn.solver.VariableBase;
import java.util.List;
import java.util.Map;

public class ElementwiseProduct
implements IExpression {
    public IExpression exp1;
    public IExpression exp2;

    public ElementwiseProduct(IExpression exp1, IExpression exp2) {
        this.exp1 = exp1;
        this.exp2 = exp2;
    }

    public String toString() {
        return this.exp1 + " * " + this.exp2;
    }

    @Override
    public Object evaluate(IEnvironment environment) {
        Object left = this.exp1.evaluate(environment);
        Object right = this.exp2.evaluate(environment);
        if (left instanceof Array && right instanceof Array) {
            Array la = (Array)left;
            Array ra = (Array)right;
            List<Object> lae = la.elements();
            List<Object> rae = ra.elements();
            if (lae.size() != rae.size()) {
                throw new UnsupportedOperationException();
            }
            Array result = new Array(lae.size());
            int index = 0;
            for (Object o : lae) {
                Double ld = (Double)o;
                Double rd = (Double)rae.get(index++);
                result.addElement(ld * rd);
            }
            return result;
        }
        if (left instanceof Array && right instanceof Double) {
            Array la = (Array)left;
            Double rd = (Double)right;
            List<Object> lae = la.elements();
            Array result = new Array(lae.size());
            for (Object o : lae) {
                Double ld = (Double)o;
                result.addElement(ld * rd);
            }
            return result;
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public IExpression withBase(IFrame frame, String prefix) {
        return new ElementwiseProduct(this.exp1.withBase(frame, prefix), this.exp2.withBase(frame, prefix));
    }

    @Override
    public Object getPossibleConstant() {
        return null;
    }

    @Override
    public IExpression rewrite(IFrame frame, Map<String, VariableBase> copies) {
        this.exp1 = this.exp1.rewrite(frame, copies);
        this.exp2 = this.exp2.rewrite(frame, copies);
        return this;
    }

    @Override
    public void accept(IExpression.ExpressionVisitor visitor) {
        visitor.visit(this);
        this.exp1.accept(visitor);
        this.exp2.accept(visitor);
    }
}

