/*
 * Decompiled with CFR 0.152.
 */
package fi.semantum.sysdyn.solver;

import fi.semantum.sysdyn.solver.Array;
import fi.semantum.sysdyn.solver.IEnvironment;
import fi.semantum.sysdyn.solver.IExpression;
import fi.semantum.sysdyn.solver.IFrame;
import fi.semantum.sysdyn.solver.VariableBase;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ElementwiseDivision
implements IExpression {
    public IExpression exp1;
    public IExpression exp2;

    public ElementwiseDivision(IExpression exp1, IExpression exp2) {
        this.exp1 = exp1;
        this.exp2 = exp2;
    }

    public String toString() {
        return this.exp1 + " / " + this.exp2;
    }

    @Override
    public Object evaluate(IEnvironment environment) {
        Object left = this.exp1.evaluate(environment);
        Object right = this.exp2.evaluate(environment);
        if (left instanceof Array && right instanceof Array) {
            Array la = (Array)left;
            Array ra = (Array)right;
            List<Object> lae = la.elements();
            List<Object> rae = ra.elements();
            if (lae.size() != rae.size()) {
                throw new UnsupportedOperationException();
            }
            Iterator li = lae.iterator();
            Iterator ri = rae.iterator();
            Array result = new Array();
            int i = 0;
            while (i < lae.size()) {
                double ld = (Double)li.next();
                double rd = (Double)ri.next();
                result.addElement(ld / rd);
                ++i;
            }
            return result;
        }
        if (left instanceof Array && right instanceof Double) {
            Array la = (Array)left;
            double rd = (Double)right;
            List<Object> lae = la.elements();
            Iterator li = lae.iterator();
            Array result = new Array();
            int i = 0;
            while (i < lae.size()) {
                double ld = (Double)li.next();
                result.addElement(ld / rd);
                ++i;
            }
            return result;
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public IExpression withBase(IFrame frame, String prefix) {
        return new ElementwiseDivision(this.exp1.withBase(frame, prefix), this.exp2.withBase(frame, prefix));
    }

    @Override
    public Object getPossibleConstant() {
        return null;
    }

    @Override
    public IExpression rewrite(IFrame frame, Map<String, VariableBase> copies) {
        this.exp1 = this.exp1.rewrite(frame, copies);
        this.exp2 = this.exp2.rewrite(frame, copies);
        return this;
    }

    @Override
    public void accept(IExpression.ExpressionVisitor visitor) {
        visitor.visit(this);
        this.exp1.accept(visitor);
        this.exp2.accept(visitor);
    }
}

