/*
 * Decompiled with CFR 0.152.
 */
package fi.semantum.sysdyn.solver;

import fi.semantum.sysdyn.solver.Environment;
import fi.semantum.sysdyn.solver.IEnvironment;
import fi.semantum.sysdyn.solver.IExpression;
import fi.semantum.sysdyn.solver.IFrame;
import fi.semantum.sysdyn.solver.Variable;
import fi.semantum.sysdyn.solver.VariableBase;
import java.util.Map;

public class Derivate
implements IExpression {
    private Variable variable;
    private IExpression[] subscripts;
    public IExpression e;

    public Derivate(Variable variable, IExpression[] subscripts, IExpression e) {
        this.variable = variable;
        this.subscripts = subscripts;
        this.e = e;
    }

    @Override
    public Object evaluate(IEnvironment _environment) {
        Environment environment = (Environment)_environment;
        Double old = (Double)environment.getValue(this.variable.base.index(_environment, this.subscripts));
        if (old == null) {
            old = 0.0;
        }
        return old + environment.step * (Double)this.e.evaluate(environment);
    }

    public String toString() {
        return this.e.toString();
    }

    @Override
    public IExpression withBase(IFrame frame, String prefix) {
        if (this.subscripts != null) {
            IExpression[] subscripts2 = new IExpression[this.subscripts.length];
            int i = 0;
            while (i < this.subscripts.length) {
                subscripts2[i] = this.subscripts[i].withBase(frame, prefix);
                ++i;
            }
            return new Derivate(this.variable.withBase(frame, prefix), subscripts2, this.e.withBase(frame, prefix));
        }
        return new Derivate(this.variable.withBase(frame, prefix), null, this.e.withBase(frame, prefix));
    }

    @Override
    public Object getPossibleConstant() {
        return null;
    }

    @Override
    public IExpression rewrite(IFrame frame, Map<String, VariableBase> copies) {
        if (this.subscripts != null) {
            int i = 0;
            while (i < this.subscripts.length) {
                this.subscripts[i] = this.subscripts[i].rewrite(frame, copies);
                ++i;
            }
        }
        this.e = this.e.rewrite(frame, copies);
        return this;
    }

    @Override
    public void accept(IExpression.ExpressionVisitor visitor) {
        visitor.visit(this);
        if (this.subscripts != null) {
            int i = 0;
            while (i < this.subscripts.length) {
                this.subscripts[i].accept(visitor);
                ++i;
            }
        }
        this.e.accept(visitor);
    }
}

