/*
 * Decompiled with CFR 0.152.
 */
package fi.semantum.sysdyn.solver;

import fi.semantum.sysdyn.solver.Constant;
import fi.semantum.sysdyn.solver.IEnvironment;
import fi.semantum.sysdyn.solver.IExpression;
import fi.semantum.sysdyn.solver.IFrame;
import fi.semantum.sysdyn.solver.VariableBase;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Array
implements IExpression {
    public static final Array FULL = new Array();
    private final ArrayList<Object> elements;

    public Array() {
        this.elements = new ArrayList();
    }

    public Array(int size) {
        this.elements = new ArrayList(size);
    }

    public Array addElement(Object element) {
        if (element instanceof Constant) {
            this.addElement(((Constant)element).value);
        } else {
            this.elements.add(element);
        }
        return this;
    }

    public void setElement(int index, Object element) {
        this.elements.set(index, element);
    }

    @Override
    public Object evaluate(IEnvironment environment) {
        return this.evaluated(environment);
    }

    public Array evaluated(IEnvironment environment) {
        Array result = new Array();
        for (Object o : this.elements) {
            if (o instanceof Array) {
                result.addElement(((Array)o).evaluated(environment));
                continue;
            }
            if (o instanceof IExpression) {
                IExpression exp = (IExpression)o;
                result.addElement(exp.evaluate(environment));
                continue;
            }
            result.addElement(o);
        }
        return result;
    }

    public String toString() {
        return this.elements.toString();
    }

    public int size(int col) {
        return this.elements.size();
    }

    public Object element(int index) {
        return this.elements.get(index);
    }

    public List<Object> elements() {
        return this.elements;
    }

    public void ensureIndex(int index, boolean subArray) {
        int needed = index + 1 - this.elements.size();
        int i = 0;
        while (i < needed) {
            this.addElement(subArray ? new Array() : null);
            ++i;
        }
    }

    @Override
    public IExpression withBase(IFrame frame, String prefix) {
        Array result = new Array();
        for (Object o : this.elements) {
            if (o instanceof Array) {
                result.addElement(((Array)o).withBase(frame, prefix));
                continue;
            }
            if (o instanceof IExpression) {
                IExpression exp = (IExpression)o;
                result.addElement(exp.withBase(frame, prefix));
                continue;
            }
            result.addElement(o);
        }
        return result;
    }

    @Override
    public Object getPossibleConstant() {
        return null;
    }

    @Override
    public IExpression rewrite(IFrame frame, Map<String, VariableBase> copies) {
        int i = 0;
        while (i < this.elements.size()) {
            Object element = this.elements.get(i);
            if (element instanceof IExpression) {
                this.elements.set(i, ((IExpression)element).rewrite(frame, copies));
            }
            ++i;
        }
        return this;
    }

    public int dimension() {
        int result = 0;
        int i = 0;
        while (i < this.elements.size()) {
            Object element = this.elements.get(i);
            result = element instanceof Array ? (result += ((Array)element).dimension()) : ++result;
            ++i;
        }
        return result;
    }

    public Array mul(double d) {
        Array result = new Array();
        for (Object o : this.elements) {
            if (o instanceof Double) {
                result.addElement((Double)o * d);
                continue;
            }
            if (o instanceof Array) {
                result.addElement(((Array)o).mul(d));
                continue;
            }
            throw new IllegalStateException();
        }
        return result;
    }

    public Array pow(double d) {
        Array result = new Array();
        for (Object o : this.elements) {
            if (o instanceof Double) {
                result.addElement(Math.pow((Double)o, d));
                continue;
            }
            if (o instanceof Array) {
                result.addElement(((Array)o).pow(d));
                continue;
            }
            throw new IllegalStateException();
        }
        return result;
    }

    public boolean validateDimensions(int[] dimensions, int index) {
        if (this.elements.size() != dimensions[index]) {
            return false;
        }
        if (index < dimensions.length - 1) {
            for (Object o : this.elements) {
                if (!(o instanceof Array)) {
                    return false;
                }
                Array arr = (Array)o;
                if (arr.validateDimensions(dimensions, index + 1)) continue;
                return false;
            }
        } else {
            for (Object o : this.elements) {
                if (!(o instanceof Array)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isScalar(Array index) {
        if (index == FULL) {
            return false;
        }
        return index.elements.size() == 1;
    }

    public Array slice(Array[] indices) {
        if (indices.length == 1) {
            if (indices[0] == FULL) {
                return this;
            }
            Array result = new Array();
            for (Object r : indices[0].elements) {
                Double d = (Double)r;
                int index = d.intValue();
                result.addElement(this.element(index));
            }
            return result;
        }
        if (indices.length == 2) {
            if (indices[0] == FULL && indices[1] == FULL) {
                return this;
            }
            if (this.isScalar(indices[0])) {
                Double d = (Double)indices[0].element(0);
                int index = d.intValue();
                Array arr = (Array)this.elements.get(index);
                if (indices[1] == FULL) {
                    return arr;
                }
                Array result = new Array();
                for (Object r : indices[1].elements) {
                    d = (Double)r;
                    index = d.intValue();
                    result.addElement(arr.element(index));
                }
                return result;
            }
            if (this.isScalar(indices[1])) {
                Double d = (Double)indices[1].element(0);
                int index1 = d.intValue();
                Array result = new Array();
                if (indices[0] == FULL) {
                    for (Object r : this.elements) {
                        Array arr = (Array)r;
                        result.addElement(arr.element(index1));
                    }
                } else {
                    for (Object r : indices[0].elements) {
                        d = (Double)r;
                        int index = d.intValue();
                        Array arr = (Array)this.element(index);
                        result.addElement(arr.element(index1));
                    }
                }
                return result;
            }
            Array result = new Array();
            for (Object r : indices[0].elements) {
                Double d = (Double)r;
                int index = d.intValue();
                Array result0 = new Array();
                Array arr = (Array)this.element(index);
                for (Object r2 : indices[1].elements) {
                    d = (Double)r2;
                    index = d.intValue();
                    result0.addElement(arr.element(index));
                }
                result.addElement(result0);
            }
            return result;
        }
        if (indices.length == 3) {
            Array result = new Array();
            int i = 0;
            while (i < indices[0].dimension()) {
                Double d0 = (Double)indices[0].element(i);
                int index0 = d0.intValue();
                Array a0 = (Array)this.element(index0);
                int j = 0;
                while (j < indices[1].dimension()) {
                    Double d1 = (Double)indices[1].element(j);
                    int index1 = d1.intValue();
                    Array a1 = (Array)a0.element(index1);
                    int k = 0;
                    while (k < indices[2].dimension()) {
                        Double d2 = (Double)indices[2].element(k);
                        int index2 = d2.intValue();
                        result.addElement(a1.element(index2));
                        ++k;
                    }
                    ++j;
                }
                ++i;
            }
            return result;
        }
        throw new IllegalStateException();
    }

    public Array add(Array other) {
        Array result = new Array();
        List<Object> lae = this.elements();
        List<Object> rae = other.elements();
        if (lae.size() != rae.size()) {
            throw new IllegalStateException();
        }
        Iterator li = lae.iterator();
        Iterator ri = rae.iterator();
        int i = 0;
        while (i < lae.size()) {
            Object l = li.next();
            Object r = ri.next();
            if (l instanceof Double && r instanceof Double) {
                result.addElement((Double)l + (Double)r);
            } else if (l instanceof Array && r instanceof Array) {
                Array arr = (Array)l;
                Array otherArr = (Array)r;
                result.addElement(arr.add(otherArr));
            } else {
                throw new IllegalStateException();
            }
            ++i;
        }
        return result;
    }

    public Array mul(Array other) {
        Array result = new Array();
        List<Object> lae = this.elements();
        List<Object> rae = other.elements();
        if (lae.size() != rae.size()) {
            throw new IllegalStateException();
        }
        Iterator li = lae.iterator();
        Iterator ri = rae.iterator();
        int i = 0;
        while (i < lae.size()) {
            Object l = li.next();
            Object r = ri.next();
            if (l instanceof Double && r instanceof Double) {
                result.addElement((Double)l * (Double)r);
            } else if (l instanceof Array && r instanceof Array) {
                Array arr = (Array)l;
                Array otherArr = (Array)r;
                result.addElement(arr.mul(otherArr));
            } else {
                throw new IllegalStateException();
            }
            ++i;
        }
        return result;
    }

    public Array pow(Array other) {
        Array result = new Array();
        List<Object> lae = this.elements();
        List<Object> rae = other.elements();
        if (lae.size() != rae.size()) {
            throw new IllegalStateException();
        }
        Iterator li = lae.iterator();
        Iterator ri = rae.iterator();
        int i = 0;
        while (i < lae.size()) {
            Object l = li.next();
            Object r = ri.next();
            if (l instanceof Double && r instanceof Double) {
                result.addElement(Math.pow((Double)l, (Double)r));
            } else if (l instanceof Array && r instanceof Array) {
                Array arr = (Array)l;
                Array otherArr = (Array)r;
                result.addElement(arr.pow(otherArr));
            } else {
                throw new IllegalStateException();
            }
            ++i;
        }
        return result;
    }

    @Override
    public void accept(IExpression.ExpressionVisitor visitor) {
        visitor.visit(this);
        int i = 0;
        while (i < this.elements.size()) {
            Object element = this.elements.get(i);
            if (element instanceof IExpression) {
                ((IExpression)element).accept(visitor);
            }
            ++i;
        }
    }

    public static Array singleton(double value) {
        Array result = new Array();
        result.addElement(value);
        return result;
    }

    public static Array slice(int start, int end) {
        Array result = new Array();
        int i = start;
        while (i <= end) {
            double d = i;
            result.addElement(d);
            ++i;
        }
        return result;
    }
}

