/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.simulation.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.contexts.IContextActivation;
import org.eclipse.ui.contexts.IContextService;
import org.simantics.simulation.experiment.IDynamicExperiment;
import org.simantics.simulation.experiment.IExperiment;
import org.simantics.simulation.experiment.IExperimentListener;
import org.simantics.simulation.project.IExperimentManager;
import org.simantics.simulation.project.IExperimentManagerListener;
import org.simantics.simulation.ui.ExperimentListener;

public class ExperimentManagerListener
implements IExperimentManagerListener {
    public static final String EXPERIMENT_CONTEXT = "org.simantics.simulation.ui.experiment";
    public static final String DYNAMIC_EXPERIMENT_CONTEXT = "org.simantics.simulation.ui.dynamicExperiment";
    static Set<IExperimentManager> managers = new HashSet<IExperimentManager>();
    IExperimentManager manager;
    Collection<IContextActivation> contextActivations = new ArrayList<IContextActivation>();

    public ExperimentManagerListener(IExperimentManager manager) {
        this.manager = manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void listenManager(IExperimentManager manager) {
        Set<IExperimentManager> set = managers;
        synchronized (set) {
            if (managers.contains(manager)) {
                return;
            }
            ExperimentManagerListener listener = new ExperimentManagerListener(manager);
            manager.addListener((IExperimentManagerListener)listener);
            managers.add(manager);
        }
    }

    public void activeExperimentLoaded(final IExperiment experiment) {
        experiment.addListener((IExperimentListener)new ExperimentListener());
        if (!PlatformUI.isWorkbenchRunning()) {
            return;
        }
        final IWorkbench workbench = PlatformUI.getWorkbench();
        workbench.getDisplay().asyncExec(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (workbench.isClosing()) {
                    return;
                }
                IContextService contextService = (IContextService)PlatformUI.getWorkbench().getService(IContextService.class);
                Collection<IContextActivation> collection = ExperimentManagerListener.this.contextActivations;
                synchronized (collection) {
                    ExperimentManagerListener.this.contextActivations.add(contextService.activateContext(ExperimentManagerListener.EXPERIMENT_CONTEXT));
                    if (experiment instanceof IDynamicExperiment) {
                        ExperimentManagerListener.this.contextActivations.add(contextService.activateContext(ExperimentManagerListener.DYNAMIC_EXPERIMENT_CONTEXT));
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activeExperimentUnloaded() {
        Collection<IContextActivation> collection = this.contextActivations;
        synchronized (collection) {
            final Collection<IContextActivation> oldContextActivations = this.contextActivations;
            this.contextActivations = new ArrayList<IContextActivation>();
            if (!PlatformUI.isWorkbenchRunning()) {
                return;
            }
            final IWorkbench workbench = PlatformUI.getWorkbench();
            workbench.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (workbench.isClosing()) {
                        return;
                    }
                    IContextService contextService = (IContextService)workbench.getService(IContextService.class);
                    contextService.deactivateContexts(oldContextActivations);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void managerDisposed() {
        Set<IExperimentManager> set = managers;
        synchronized (set) {
            this.manager.removeListener((IExperimentManagerListener)this);
            managers.remove(this.manager);
        }
    }
}

