/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scenegraph.loader;

import gnu.trove.set.hash.THashSet;
import java.util.Set;
import org.simantics.Simantics;
import org.simantics.db.Disposable;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.common.primitiverequest.PossibleResource;
import org.simantics.db.common.procedure.adapter.ListenerSupport;
import org.simantics.db.common.request.UnaryRead;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.request.ResourceVariable;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.VariableRepository;
import org.simantics.db.request.ReadInterface;
import org.simantics.scenegraph.INode;
import org.simantics.scenegraph.ParentNode;
import org.simantics.scenegraph.loader.ScenegraphLoader;
import org.simantics.scenegraph.loader.ScenegraphLoaderUtils;
import org.simantics.scenegraph.loader.ScenegraphVariable;
import org.simantics.utils.datastructures.Pair;

public class ScenegraphLoaderProcess
implements Disposable,
ListenerSupport {
    private final String name;
    final Class<?> loaderClass;
    protected INode root;
    private boolean disposed = false;
    protected final Set<String> registeredURIs = new THashSet();

    public ScenegraphLoaderProcess(String name) {
        this(null, ScenegraphLoader.class, name);
    }

    public ScenegraphLoaderProcess(INode root, String name) {
        this(root, ScenegraphLoader.class, name);
    }

    public ScenegraphLoaderProcess(INode root, Class<?> loaderClass, String name) {
        this.root = root;
        this.loaderClass = loaderClass;
        this.name = name;
    }

    public INode getRoot() {
        return this.root;
    }

    public String toString() {
        return this.name;
    }

    protected void initialize(RequestProcessor processor, Variable configuration) throws DatabaseException {
    }

    public final <N extends ParentNode<?>> N load(String curi, Resource runtime) throws DatabaseException {
        return this.load((RequestProcessor)Simantics.getSession(), curi, runtime);
    }

    public final <N extends ParentNode<?>> N load(RequestProcessor processor, String curi, Resource runtime) throws DatabaseException {
        Resource resource = (Resource)processor.sync((ReadInterface)new PossibleResource(curi));
        if (resource == null) {
            throw new IllegalArgumentException("The given URI is invalid: " + curi);
        }
        return this.load(processor, resource, runtime);
    }

    public final <N extends ParentNode<?>> N load(Resource configuration, Resource runtime) throws DatabaseException {
        return this.load((RequestProcessor)Simantics.getSession(), configuration, runtime);
    }

    public final <N extends ParentNode<?>> N load(RequestProcessor processor, Resource configuration, Resource runtime) throws DatabaseException {
        ParentNode root = (ParentNode)this.getRoot();
        return this.load(processor, ScenegraphLoaderProcess.getVariable(processor, this, configuration, runtime, (INode)root));
    }

    public final Variable getVariable(RequestProcessor processor, String curi, Resource runtime) throws DatabaseException {
        Resource resource = (Resource)processor.sync((ReadInterface)new PossibleResource(curi));
        if (resource == null) {
            throw new IllegalArgumentException("The given URI is invalid: " + curi);
        }
        return ScenegraphLoaderProcess.getVariable(processor, this, resource, runtime, this.root);
    }

    public static final Variable getVariable(RequestProcessor processor, ScenegraphLoaderProcess process, final Resource configuration, final Resource runtime, final INode root) throws DatabaseException {
        assert (root != null);
        Pair result = (Pair)processor.sync((ReadInterface)new UnaryRead<INode, Pair<Variable, String>>(root){

            public Pair<Variable, String> perform(ReadGraph graph) throws DatabaseException {
                Variable conf = (Variable)graph.sync((ReadInterface)new ResourceVariable(configuration));
                ScenegraphVariable result = new ScenegraphVariable(conf, configuration, runtime, root);
                return Pair.make((Object)((Object)result), (Object)result.getURI(graph));
            }
        });
        VariableRepository.register((String)((String)result.second), (Variable)((Variable)result.first));
        if (process != null) {
            process.registeredURIs.add((String)result.second);
        }
        return (Variable)result.first;
    }

    public final <N extends ParentNode<?>> N load(RequestProcessor processor, Variable configuration) throws DatabaseException {
        this.initialize(processor, configuration);
        ParentNode root = (ParentNode)this.getRoot();
        this.load(processor, configuration, root);
        return (N)root;
    }

    <T extends ScenegraphLoader> Class<T> getLoaderClass() {
        return ScenegraphLoader.class;
    }

    protected ScenegraphLoader getLoader(RequestProcessor processor, Variable configuration) throws DatabaseException {
        return (ScenegraphLoader)processor.sync((ReadInterface)new UnaryRead<Variable, ScenegraphLoader>(configuration){

            public ScenegraphLoader perform(ReadGraph graph) throws DatabaseException {
                return (ScenegraphLoader)((Variable)this.parameter).adapt(graph, ScenegraphLoaderProcess.this.getLoaderClass());
            }
        });
    }

    private final INode load(RequestProcessor processor, Variable configuration, ParentNode<?> current) throws DatabaseException {
        ScenegraphLoader loader = this.getLoader(processor, configuration);
        INode node = loader.create(processor, this, current, configuration);
        if (node instanceof ParentNode) {
            for (Variable child : ScenegraphLoaderUtils.getChildren(processor, configuration)) {
                this.load(processor, child, (ParentNode)node);
            }
        }
        return node;
    }

    public void exception(Throwable t) {
        Logger.defaultLogError((Throwable)t);
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    public void dispose() {
        this.disposed = true;
    }
}

