/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.commands.internal.serialization;

import org.simantics.db.Resource;
import org.simantics.scl.commands.internal.StringConverterFactory;
import org.simantics.scl.commands.internal.serialization.CommandSerializer;
import org.simantics.scl.commands.internal.serialization.CommandSerializerImpl;
import org.simantics.scl.commands.internal.serialization.ErrorSerializer;
import org.simantics.scl.compiler.common.errors.SCLError;
import org.simantics.scl.compiler.top.SCLErrorFormatter;
import org.simantics.scl.compiler.top.SCLExpressionCompilationException;
import org.simantics.scl.compiler.top.ValueNotFound;
import org.simantics.scl.runtime.function.Function;
import org.simantics.scl.runtime.function.Function2;
import org.simantics.scl.types.Type;

public class CommandSerializerFactory {
    public static CommandSerializer create(String name, Type[] parameterTypes) {
        Function[] stringConverters = new Function[parameterTypes.length];
        int i = 0;
        while (i < parameterTypes.length) {
            try {
                stringConverters[i] = StringConverterFactory.stringConverterFor(parameterTypes[i]);
            }
            catch (SCLExpressionCompilationException e) {
                System.err.println("Failed to create a string converter for type " + parameterTypes[i] + ".");
                System.err.println(SCLErrorFormatter.toString(null, (SCLError[])e.getErrors()));
                return new ErrorSerializer(name);
            }
            catch (ValueNotFound e) {
                System.err.println("Failed to create a string converter for type " + parameterTypes[i] + ".");
                System.err.println("Didn't find Simantics/GShow/gshow.");
                return new ErrorSerializer(name);
            }
            ++i;
        }
        return new CommandSerializerImpl(name, (Function2<Resource, Object, String>[])stringConverters);
    }
}

