/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.commands.internal.checker;

import org.simantics.scl.commands.internal.checker.BooleanCheckItem;
import org.simantics.scl.commands.internal.checker.CheckItem;
import org.simantics.scl.commands.internal.checker.FunctionCheckItem;
import org.simantics.scl.commands.internal.checker.MaybeCheckItem;
import org.simantics.scl.compiler.elaboration.modules.SCLValue;
import org.simantics.scl.compiler.top.ValueNotFound;
import org.simantics.scl.osgi.SCLOsgi;
import org.simantics.scl.types.TCon;
import org.simantics.scl.types.Type;
import org.simantics.scl.types.Types;
import org.simantics.scl.types.exceptions.MatchException;
import org.simantics.scl.types.util.MultiFunction;

public class Checker {
    Object check;
    CheckItem item;

    private Checker(Object check, CheckItem item) {
        this.check = check;
        this.item = item;
    }

    public boolean check(Object[] parameters) {
        return this.item.check(this.check, parameters, 0);
    }

    private static CheckItem checkItemForType(Type type) throws MatchException {
        if (type == Types.BOOLEAN) {
            return BooleanCheckItem.INSTANCE;
        }
        if (Types.isFunction((Type)type)) {
            MultiFunction mfun = Types.matchFunction((Type)type, (int)1);
            return new FunctionCheckItem(mfun.parameterTypes[0], Checker.checkItemForType(mfun.returnType));
        }
        if (Types.isApply((Type)Types.MAYBE, (int)1, (Type)type)) {
            Type componentType = Types.matchApply((TCon)Types.MAYBE, (Type)type);
            return new MaybeCheckItem(Checker.checkItemForType(componentType));
        }
        throw new MatchException();
    }

    public static Checker create(String name) {
        try {
            SCLValue checkRef = SCLOsgi.INSTANCE.getValueCache().getValueRef(name);
            Object check = SCLOsgi.INSTANCE.getValue(name);
            return new Checker(check, Checker.checkItemForType(checkRef.getType()));
        }
        catch (ValueNotFound e) {
            return new Checker(Boolean.TRUE, BooleanCheckItem.INSTANCE);
        }
        catch (MatchException e) {
            e.printStackTrace();
            return new Checker(Boolean.FALSE, BooleanCheckItem.INSTANCE);
        }
    }
}

