/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.graph.compiler.tests;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import junit.framework.Assert;
import org.junit.Before;
import org.junit.Test;
import org.simantics.graph.compiler.CompilationResult;
import org.simantics.graph.compiler.ExternalFileLoader;
import org.simantics.graph.compiler.GraphCompiler;
import org.simantics.graph.compiler.GraphCompilerPreferences;
import org.simantics.graph.representation.TransferableGraph1;
import org.simantics.ltk.ISource;
import org.simantics.ltk.LocalResourceSource;

public class GraphCompilerTests {
    @Before
    public void initialize() {
    }

    public CompilationResult compile(String source) throws Exception {
        ArrayList<ISource> sources = new ArrayList<ISource>();
        sources.add((ISource)new LocalResourceSource(GraphCompilerTests.class, source));
        ArrayList<TransferableGraph1> dependencies = new ArrayList<TransferableGraph1>();
        dependencies.add(GraphCompiler.read(GraphCompilerTests.class.getResourceAsStream("graph.tg")));
        ExternalFileLoader fileLoader = new ExternalFileLoader(){

            @Override
            public byte[] load(String fileName) throws IOException {
                throw new FileNotFoundException();
            }
        };
        GraphCompilerPreferences preferences = new GraphCompilerPreferences();
        preferences.validate = true;
        return GraphCompiler.compile("1.0", sources, dependencies, fileLoader, preferences);
    }

    @Test
    public void testUndefinedVariable() throws Exception {
        CompilationResult result = this.compile("graphs/UndefinedVariable.pgraph");
        Assert.assertEquals((int)1, (int)result.getErrors().size());
    }

    @Test
    public void testUndefinedConcept() throws Exception {
        CompilationResult result = this.compile("graphs/UndefinedConcept.pgraph");
        Assert.assertEquals((int)1, (int)result.getErrors().size());
    }

    @Test
    public void testDomainAndRangeSyntax() throws Exception {
        CompilationResult result = this.compile("graphs/DomainAndRangeSyntax.pgraph");
        Assert.assertEquals((int)0, (int)result.getErrors().size());
    }

    @Test
    public void testLists() throws Exception {
        CompilationResult result = this.compile("graphs/Lists.pgraph");
        Assert.assertEquals((int)0, (int)result.getErrors().size());
        Assert.assertEquals((int)8, (int)(result.getGraph().statements.length / 4));
        result.getGraph().print();
    }
}

