/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.graph.compiler.internal.values;

import java.util.Collection;
import org.antlr.runtime.tree.Tree;
import org.simantics.databoard.binding.Binding;
import org.simantics.graph.compiler.internal.store.IPreValue;
import org.simantics.graph.compiler.internal.translation.DataValueTranslator;
import org.simantics.graph.query.Path;
import org.simantics.graph.query.Paths;
import org.simantics.ltk.ISource;
import org.simantics.ltk.Location;
import org.simantics.ltk.Problem;
import org.simantics.ltk.antlr.ANTLRUtils;

public class TreeValue
implements IPreValue {
    ISource source;
    Tree tree;

    public TreeValue(ISource source, Tree tree) {
        this.source = source;
        this.tree = tree;
    }

    @Override
    public Object toValue(Binding binding, Collection<Problem> problems) {
        return new DataValueTranslator(this.source, problems).translate(this.tree, binding);
    }

    public Tree getTree() {
        return this.tree;
    }

    @Override
    public Path getDefaultType(Paths paths) {
        Tree b = this.tree;
        while (b.getType() == 38 && b.getChildCount() == 1) {
            b = b.getChild(0);
        }
        switch (b.getType()) {
            case 54: {
                return paths.Integer;
            }
            case 56: {
                return paths.Double;
            }
            case 61: {
                return paths.String;
            }
            case 43: 
            case 44: {
                return paths.Boolean;
            }
            case 36: {
                return paths.Variant;
            }
            case 37: {
                if (b.getChildCount() <= 0) break;
                switch (b.getChild(0).getType()) {
                    case 54: 
                    case 56: {
                        int i = 0;
                        while (i < b.getChildCount()) {
                            if (b.getChild(i).getType() == 56) {
                                return paths.DoubleArray;
                            }
                            ++i;
                        }
                        return paths.IntegerArray;
                    }
                    case 61: {
                        return paths.StringArray;
                    }
                    case 43: 
                    case 44: {
                        return paths.BooleanArray;
                    }
                }
            }
        }
        return null;
    }

    @Override
    public Location getLocation() {
        return ANTLRUtils.location((ISource)this.source, (Tree)this.tree);
    }

    public String toString() {
        return this.tree.getText();
    }
}

