/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.graph.compiler.internal.validation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.Callable;
import org.simantics.graph.compiler.GraphCompilerPreferences;
import org.simantics.graph.compiler.ValidationMode;
import org.simantics.graph.compiler.internal.store.LocationStore;
import org.simantics.graph.query.CompositeGraph;
import org.simantics.graph.query.Path;
import org.simantics.graph.query.Paths;
import org.simantics.graph.query.Res;
import org.simantics.graph.store.GraphStore;
import org.simantics.graph.store.IdRes;
import org.simantics.graph.utils.GraphExecutor;
import org.simantics.ltk.Location;
import org.simantics.ltk.Problem;

public class ValidateGraph
implements Runnable {
    CompositeGraph graph;
    Collection<Problem> problems;
    GraphStore store;
    GraphCompilerPreferences preferences;
    Paths paths;

    public ValidateGraph(CompositeGraph graph, Collection<Problem> problems, GraphStore store, GraphCompilerPreferences preferences) {
        this.graph = graph;
        this.problems = problems;
        this.store = store;
        this.preferences = preferences;
        this.paths = graph.getPaths();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void emit(int id, ValidationMode mode, String message) {
        LocationStore locations = (LocationStore)this.store.getStore(LocationStore.class);
        Location location = locations.getLocation(id);
        Problem problem = new Problem(location, message);
        Collection<Problem> collection = this.problems;
        synchronized (collection) {
            this.problems.add(problem);
        }
    }

    public void validate(int id, Res resource) {
        if (!this.graph.rawGetObjects(resource, (Res)this.paths.SubrelationOf).isEmpty()) {
            for (Res res : this.graph.rawGetObjects(resource, (Res)this.paths.InverseOf)) {
                if (resource instanceof IdRes && res instanceof Path) {
                    this.emit(id, ValidationMode.ERROR, "Resource " + resource + " doesn't have URI but its inverse has.");
                }
                if (!(res instanceof IdRes) || !(resource instanceof Path)) continue;
                this.emit(this.store.resToId(res), ValidationMode.ERROR, "Resource " + res + " doesn't have URI but its inverse has.");
            }
        } else if (this.preferences.validateResourceHasType != ValidationMode.IGNORE && this.graph.rawGetObjects(resource, (Res)this.paths.InstanceOf).isEmpty() && this.graph.rawGetObjects(resource, (Res)this.paths.Inherits).isEmpty()) {
            this.emit(id, this.preferences.validateResourceHasType, "Resource " + resource + " does not have a type, it has to instantiate or inherit some other resource.");
        }
    }

    @Override
    public void run() {
        int resourceCount = this.store.identities.getResourceCount();
        int segmentLength = Math.max(256, resourceCount / GraphExecutor.EXECUTOR_THREADS / 4 + 1);
        ArrayList<1> tasks = new ArrayList<1>();
        int segmentStart_ = 0;
        while (segmentStart_ < resourceCount) {
            final int segmentStart = segmentStart_;
            final int segmentEnd = Math.min(segmentStart + segmentLength, resourceCount);
            tasks.add(new Callable<Object>(){

                /*
                 * Unable to fully structure code
                 */
                @Override
                public Object call() {
                    id = segmentStart;
                    while (id < segmentEnd) {
                        block4: {
                            block3: {
                                res = ValidateGraph.this.store.idToRes(id);
                                if (!(res instanceof Path)) ** GOTO lbl-1000
                                if (!ValidateGraph.this.store.identities.isNewResource(id)) break block3;
                                if (ValidateGraph.this.graph.countOccurences(res) <= 1) ** GOTO lbl-1000
                                ValidateGraph.access$0(ValidateGraph.this, id, ValidationMode.ERROR, "Resource " + res + " is already defined in dependencies, but it is marked new in this graph.");
                                break block4;
                            }
                            if (ValidateGraph.this.graph.countOccurences(res) <= 1) {
                                ValidateGraph.access$0(ValidateGraph.this, id, ValidationMode.ERROR, "Resource " + res + " is not defined in dependencies and it is not marked new in this graph.");
                            } else lbl-1000:
                            // 3 sources

                            {
                                ValidateGraph.this.validate(id, res);
                            }
                        }
                        ++id;
                    }
                    return null;
                }
            });
            segmentStart_ += segmentLength;
        }
        try {
            GraphExecutor.EXECUTOR.invokeAll(tasks);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    static /* synthetic */ void access$0(ValidateGraph validateGraph, int n, ValidationMode validationMode, String string) {
        validateGraph.emit(n, validationMode, string);
    }
}

