/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.graph.compiler.internal.translation;

import java.util.Collection;
import org.antlr.runtime.tree.Tree;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.ArrayBinding;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.BooleanBinding;
import org.simantics.databoard.binding.ByteBinding;
import org.simantics.databoard.binding.DoubleBinding;
import org.simantics.databoard.binding.FloatBinding;
import org.simantics.databoard.binding.IntegerBinding;
import org.simantics.databoard.binding.LongBinding;
import org.simantics.databoard.binding.MapBinding;
import org.simantics.databoard.binding.OptionalBinding;
import org.simantics.databoard.binding.RecordBinding;
import org.simantics.databoard.binding.StringBinding;
import org.simantics.databoard.binding.UnionBinding;
import org.simantics.databoard.binding.VariantBinding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.type.Datatype;
import org.simantics.graph.compiler.internal.translation.DataTypeTranslator;
import org.simantics.ltk.ISource;
import org.simantics.ltk.Problem;
import org.simantics.ltk.antlr.ANTLRUtils;

public class DataValueTranslator {
    ISource source;
    Collection<Problem> problems;

    public DataValueTranslator(ISource source, Collection<Problem> problems) {
        this.source = source;
        this.problems = problems;
    }

    public Object translate(Tree _tree, Binding binding) {
        while (_tree.getType() == 38 && _tree.getChildCount() == 1) {
            _tree = _tree.getChild(0);
        }
        final Tree tree = _tree;
        return binding.accept((Binding.Visitor)new Binding.Visitor<Object>(){

            public Object visit(ArrayBinding b) {
                if (tree.getType() == 37) {
                    int count = tree.getChildCount();
                    Object[] components = new Object[count];
                    Binding componentBinding = b.getComponentBinding();
                    int i = 0;
                    while (i < count) {
                        components[i] = DataValueTranslator.this.translate(tree.getChild(i), componentBinding);
                        ++i;
                    }
                    return b.createUnchecked(components);
                }
                DataValueTranslator.this.typeError(tree, (Binding)b);
                return b.createDefaultUnchecked();
            }

            public Object visit(BooleanBinding b) {
                if (tree.getType() == 43) {
                    return b.createUnchecked(Boolean.valueOf(true));
                }
                if (tree.getType() == 44) {
                    return b.createUnchecked(Boolean.valueOf(false));
                }
                DataValueTranslator.this.typeError(tree, (Binding)b);
                return b.createDefaultUnchecked();
            }

            public Object visit(DoubleBinding b) {
                if (tree.getType() == 54 || tree.getType() == 56) {
                    return b.createUnchecked(tree.getText());
                }
                DataValueTranslator.this.typeError(tree, (Binding)b);
                return b.createDefaultUnchecked();
            }

            public Object visit(FloatBinding b) {
                if (tree.getType() == 54 || tree.getType() == 56) {
                    return b.createUnchecked(tree.getText());
                }
                DataValueTranslator.this.typeError(tree, (Binding)b);
                return b.createDefaultUnchecked();
            }

            public Object visit(IntegerBinding b) {
                if (tree.getType() == 54) {
                    return b.createUnchecked(tree.getText());
                }
                DataValueTranslator.this.typeError(tree, (Binding)b);
                return b.createDefaultUnchecked();
            }

            public Object visit(ByteBinding b) {
                if (tree.getType() == 54) {
                    return b.createUnchecked(tree.getText());
                }
                DataValueTranslator.this.typeError(tree, (Binding)b);
                return b.createDefaultUnchecked();
            }

            public Object visit(LongBinding b) {
                if (tree.getType() == 54) {
                    return b.createUnchecked(tree.getText());
                }
                DataValueTranslator.this.typeError(tree, (Binding)b);
                return b.createDefaultUnchecked();
            }

            public Object visit(OptionalBinding b) {
                if (tree.getType() == 35) {
                    return b.createNoValueUnchecked();
                }
                return b.createValueUnchecked(DataValueTranslator.this.translate(tree, b.getComponentBinding()));
            }

            public Object visit(RecordBinding b) {
                Object[] components;
                int count;
                boolean hadError = false;
                if (tree.getType() == 40) {
                    count = tree.getChildCount();
                    components = new Object[b.componentBindings.length];
                    boolean[] setValues = new boolean[b.componentBindings.length];
                    int i = 0;
                    while (i < count) {
                        Tree assignment = tree.getChild(i);
                        String field = assignment.getChild(0).getText();
                        Integer comp = b.type().getComponentIndex(field);
                        if (comp == null) {
                            hadError = true;
                            DataValueTranslator.this.problems.add(new Problem(ANTLRUtils.location((ISource)DataValueTranslator.this.source, (Tree)tree), "Record type " + b.type() + " does not have a field " + field + "."));
                        } else {
                            components[comp.intValue()] = DataValueTranslator.this.translate(assignment.getChild(1), b.getComponentBinding(comp.intValue()));
                            setValues[comp.intValue()] = true;
                        }
                        ++i;
                    }
                    try {
                        i = 0;
                        while (i < b.componentBindings.length) {
                            if (!setValues[i]) {
                                if (b.componentBindings[i] instanceof OptionalBinding) {
                                    components[i] = b.componentBindings[i].createDefault();
                                } else {
                                    DataValueTranslator.this.problems.add(new Problem(ANTLRUtils.location((ISource)DataValueTranslator.this.source, (Tree)tree), "Not all fields of the record are given."));
                                }
                                return b.createDefaultUnchecked();
                            }
                            ++i;
                        }
                        return b.create(components);
                    }
                    catch (BindingException bindingException) {
                        // empty catch block
                    }
                }
                if (tree.getType() == 38 && (count = tree.getChildCount()) == b.getComponentCount()) {
                    components = new Object[count];
                    int i = 0;
                    while (i < count) {
                        components[i] = DataValueTranslator.this.translate(tree.getChild(i), b.getComponentBinding(i));
                        ++i;
                    }
                    return b.createUnchecked(components);
                }
                if (!hadError) {
                    DataValueTranslator.this.typeError(tree, (Binding)b);
                }
                return b.createDefaultUnchecked();
            }

            public Object visit(StringBinding b) {
                if (tree.getType() == 61) {
                    String str = tree.getText();
                    if (str.charAt(1) == '\"' && str.length() >= 6) {
                        return b.createUnchecked(str.substring(3, str.length() - 3));
                    }
                    return b.createUnchecked(str.substring(1, str.length() - 1));
                }
                DataValueTranslator.this.typeError(tree, (Binding)b);
                return b.createDefaultUnchecked();
            }

            public Object visit(UnionBinding b) {
                if (tree.getType() == 39) {
                    String tag = tree.getChild(0).getText();
                    Integer comp = b.type().getComponentIndex(tag);
                    if (comp != null) {
                        if (tree.getChildCount() == 2) {
                            return b.createUnchecked(comp.intValue(), DataValueTranslator.this.translate(tree.getChild(1), b.getComponentBinding(comp.intValue())));
                        }
                        Binding binding = b.getComponentBinding(comp.intValue());
                        if (binding instanceof RecordBinding && ((RecordBinding)binding).getComponentCount() == 0) {
                            return b.createUnchecked(comp.intValue(), ((RecordBinding)binding).createUnchecked(new Object[0]));
                        }
                        DataValueTranslator.this.typeError(tree, binding);
                    }
                }
                DataValueTranslator.this.typeError(tree, (Binding)b);
                return b.createDefaultUnchecked();
            }

            public Object visit(VariantBinding b) {
                if (tree.getType() == 36) {
                    Datatype type = new DataTypeTranslator(DataValueTranslator.this.source, DataValueTranslator.this.problems).translate(tree.getChild(0));
                    Binding binding = Bindings.getBinding((Datatype)type);
                    Object value = DataValueTranslator.this.translate(tree.getChild(1), binding);
                    return b.createUnchecked(binding, value);
                }
                DataValueTranslator.this.typeError(tree, (Binding)b);
                return b.createDefaultUnchecked();
            }

            public Object visit(MapBinding b) {
                if (tree.getType() == 41) {
                    int count = tree.getChildCount();
                    Object[] keys = new Object[count];
                    Object[] values = new Object[count];
                    Binding keyBinding = b.getKeyBinding();
                    Binding valueBinding = b.getValueBinding();
                    int i = 0;
                    while (i < count) {
                        keys[i] = DataValueTranslator.this.translate(tree.getChild(i).getChild(0), keyBinding);
                        values[i] = DataValueTranslator.this.translate(tree.getChild(i).getChild(1), valueBinding);
                        ++i;
                    }
                    return b.createUnchecked(keys, values);
                }
                DataValueTranslator.this.typeError(tree, (Binding)b);
                return b.createDefaultUnchecked();
            }
        });
    }

    private void typeError(Tree tree, Binding binding) {
        this.problems.add(new Problem(ANTLRUtils.location((ISource)this.source, (Tree)tree), "Value does not correspond to the data type " + binding.type() + "."));
    }
}

