/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.prelude;

import gnu.trove.map.hash.THashMap;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import org.simantics.scl.compiler.elaboration.modules.Module;
import org.simantics.scl.compiler.parsing.declarations.DImportAst;
import org.simantics.scl.compiler.top.BytecodeContainer;
import org.simantics.scl.compiler.top.ClassResourceSourceLoader;
import org.simantics.scl.compiler.top.MapBytecodeContainer;
import org.simantics.scl.compiler.top.MapClassLoader;
import org.simantics.scl.compiler.top.SCLSourceLoader;
import org.simantics.scl.compiler.top.StandardModuleLoader;

public class PreludeCache {
    private static volatile Module[] PRELUDE;
    private static volatile Map<String, byte[]> PRELUDE_CLASSES;
    private static volatile ClassLoader PRELUDE_CLASS_LOADER;
    private static final Object LOCK;

    static {
        LOCK = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void ensurePreludeIsCompiled() {
        if (PRELUDE == null) {
            Object object = LOCK;
            synchronized (object) {
                if (PRELUDE == null) {
                    try {
                        PreludeCache.compilePrelude();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    public static Module[] getPrelude() {
        PreludeCache.ensurePreludeIsCompiled();
        return PRELUDE;
    }

    public static Map<String, byte[]> getPreludeClasses() {
        PreludeCache.ensurePreludeIsCompiled();
        return PRELUDE_CLASSES;
    }

    public static ClassLoader getPreludeClassLoader() {
        PreludeCache.ensurePreludeIsCompiled();
        return PRELUDE_CLASS_LOADER;
    }

    private static void compilePrelude() throws IOException {
        ClassResourceSourceLoader sourceLoader = new ClassResourceSourceLoader(PreludeCache.class);
        THashMap classes = new THashMap();
        MapBytecodeContainer container = new MapBytecodeContainer((Map)classes);
        StandardModuleLoader moduleLoader = new StandardModuleLoader((SCLSourceLoader)sourceLoader, (BytecodeContainer)container){

            protected DImportAst[] getBuiltinImports() {
                return DImportAst.EMPTY_ARRAY;
            }
        };
        moduleLoader.loadModule("StandardLibrary");
        Collection modules = moduleLoader.getModules();
        PRELUDE = modules.toArray(new Module[modules.size()]);
        PRELUDE_CLASSES = classes;
        PRELUDE_CLASS_LOADER = new MapClassLoader(PreludeCache.class.getClassLoader(), PRELUDE_CLASSES);
    }

    public static void reset() {
        PRELUDE = null;
        PRELUDE_CLASSES = null;
        PRELUDE_CLASS_LOADER = null;
    }
}

