/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.types.kinds;

import org.simantics.scl.types.exceptions.KindUnificationException;
import org.simantics.scl.types.kinds.KArrow;
import org.simantics.scl.types.kinds.KCon;
import org.simantics.scl.types.kinds.KMetaVar;
import org.simantics.scl.types.kinds.Kind;

public class Kinds {
    public static final KCon STAR = new KCon("*");
    public static final KCon EFFECT = new KCon("E");
    public static final Kind STAR_TO_STAR = new KArrow(STAR, STAR);
    public static final Kind STAR_TO_STAR_TO_STAR = new KArrow(STAR, STAR_TO_STAR);

    public static KArrow arrow(Kind domain, Kind range) {
        return new KArrow(domain, range);
    }

    public static KMetaVar metaVar() {
        return new KMetaVar();
    }

    public static Kind canonical(Kind a) {
        while (a instanceof KMetaVar) {
            KMetaVar mv = (KMetaVar)a;
            if (mv.ref == null) {
                return a;
            }
            a = mv.ref;
        }
        return a;
    }

    public static void unifyWithStar(Kind a) throws KindUnificationException {
        if ((a = Kinds.canonical(a)) == STAR) {
            return;
        }
        if (a instanceof KMetaVar) {
            ((KMetaVar)a).ref = STAR;
        }
        throw new KindUnificationException();
    }

    public static void unify(Kind a, Kind b) throws KindUnificationException {
        if ((a = Kinds.canonical(a)) == (b = Kinds.canonical(b))) {
            return;
        }
        if (a instanceof KMetaVar) {
            ((KMetaVar)a).setRef(b);
            return;
        }
        if (b instanceof KMetaVar) {
            ((KMetaVar)b).setRef(a);
            return;
        }
        if (a instanceof KArrow && b instanceof KArrow) {
            KArrow arrowA = (KArrow)a;
            KArrow arrowB = (KArrow)b;
            Kinds.unify(arrowA.domain, arrowB.domain);
            Kinds.unify(arrowA.range, arrowB.range);
            return;
        }
        throw new KindUnificationException();
    }

    public static boolean equalsCanonical(Kind a, Kind b) {
        if (a == b) {
            return true;
        }
        if (!(a instanceof KArrow)) {
            return false;
        }
        if (!(b instanceof KArrow)) {
            return false;
        }
        KArrow arrowA = (KArrow)a;
        KArrow arrowB = (KArrow)b;
        return Kinds.equals(arrowA.domain, arrowB.domain) && Kinds.equals(arrowA.range, arrowB.range);
    }

    public static boolean equals(Kind a, Kind b) {
        return Kinds.equalsCanonical(Kinds.canonical(a), Kinds.canonical(b));
    }
}

