/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.types.internal.ast;

import java.util.ArrayList;
import java.util.Collections;
import org.simantics.scl.types.TCon;
import org.simantics.scl.types.TPred;
import org.simantics.scl.types.Type;
import org.simantics.scl.types.Types;
import org.simantics.scl.types.exceptions.Problem;
import org.simantics.scl.types.exceptions.SCLTypeParseException;
import org.simantics.scl.types.internal.TypeElaborationContext;
import org.simantics.scl.types.internal.ast.TApplyAst;
import org.simantics.scl.types.internal.ast.TConAst;

public abstract class TypeAst {
    public String toString() {
        StringBuilder b = new StringBuilder();
        this.toString(b);
        return b.toString();
    }

    public abstract void toString(StringBuilder var1);

    public void toString(StringBuilder b, int outerPrecedence) {
        if (this.getPrecedence() >= outerPrecedence) {
            b.append('(');
            this.toString(b);
            b.append(')');
        } else {
            this.toString(b);
        }
    }

    public abstract Type toType(TypeElaborationContext var1) throws SCLTypeParseException;

    public static Type[] toTypes(TypeElaborationContext context, TypeAst[] typeAsts) throws SCLTypeParseException {
        Type[] result = new Type[typeAsts.length];
        int i = 0;
        while (i < typeAsts.length) {
            result[i] = typeAsts[i].toType(context);
            ++i;
        }
        return result;
    }

    public TPred toTFuncApply(TypeElaborationContext context) throws SCLTypeParseException {
        ArrayList<Type> parameters = new ArrayList<Type>();
        TypeAst cur = this;
        while (cur instanceof TApplyAst) {
            TApplyAst apply = (TApplyAst)cur;
            parameters.add(apply.parameter.toType(context));
            cur = apply.function;
        }
        if (cur instanceof TConAst) {
            TConAst con = (TConAst)cur;
            Collections.reverse(parameters);
            return Types.pred((TCon)con.toType(context), parameters.toArray(new Type[parameters.size()]));
        }
        throw new SCLTypeParseException(new Problem(0, 0, "Invalid constraint."));
    }

    public abstract int getPrecedence();
}

