/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.types.internal;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;

public class HashConsing<T> {
    private double loadFactor = 0.75;
    private Entry<T>[] table = new Entry[16];
    private int size = 0;
    private int threshold = (int)((double)this.table.length * this.loadFactor);
    private final ReferenceQueue<T> queue = new ReferenceQueue();

    public synchronized T canonical(T candidate) {
        int h = this.hashCode(candidate);
        this.expungeStaleEntries();
        Entry<T>[] tab = this.table;
        int i = HashConsing.indexFor(h, tab.length);
        Entry e = tab[i];
        while (e != null) {
            Object cur = e.get();
            if (h == e.hash && cur != null && this.equals(cur, candidate)) {
                return cur;
            }
            e = e.next;
        }
        e = tab[i];
        tab[i] = new Entry<T>(candidate, this.queue, h, e);
        if (++this.size >= this.threshold) {
            this.resize(tab.length * 2);
        }
        return candidate;
    }

    private void resize(int newCapacity) {
        this.expungeStaleEntries();
        Entry<T>[] oldTable = this.table;
        Entry[] newTable = new Entry[newCapacity];
        this.transfer(oldTable, newTable);
        this.table = newTable;
        if (this.size >= this.threshold / 2) {
            this.threshold = (int)((double)newCapacity * this.loadFactor);
        } else {
            this.expungeStaleEntries();
            this.transfer(newTable, oldTable);
            this.table = oldTable;
        }
    }

    private void transfer(Entry<T>[] src, Entry<T>[] dest) {
        int j = 0;
        while (j < src.length) {
            Entry e = src[j];
            src[j] = null;
            while (e != null) {
                Entry next = e.next;
                Object key = e.get();
                if (key == null) {
                    e.next = null;
                    --this.size;
                } else {
                    int i = HashConsing.indexFor(e.hash, dest.length);
                    e.next = (Entry)dest[i];
                    dest[i] = e;
                }
                e = next;
            }
            ++j;
        }
    }

    private void expungeStaleEntries() {
        Entry e;
        block0: while ((e = (Entry)this.queue.poll()) != null) {
            Entry prev;
            int h = e.hash;
            int i = HashConsing.indexFor(h, this.table.length);
            Entry p = prev = this.table[i];
            while (p != null) {
                Entry next = p.next;
                if (p == e) {
                    if (prev == e) {
                        this.table[i] = next;
                    } else {
                        prev.next = next;
                    }
                    e.next = null;
                    --this.size;
                    continue block0;
                }
                prev = p;
                p = next;
            }
        }
    }

    private static int indexFor(int h, int length) {
        return h & length - 1;
    }

    protected int hashCode(T obj) {
        return obj.hashCode();
    }

    protected boolean equals(T a, T b) {
        return a.equals(b);
    }

    private static class Entry<T>
    extends WeakReference<T> {
        private final int hash;
        private Entry<T> next;

        Entry(T value, ReferenceQueue<T> queue, int hash, Entry<T> next) {
            super(value, queue);
            this.hash = hash;
            this.next = next;
        }
    }
}

