/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.types.effects;

import gnu.trove.map.hash.TObjectIntHashMap;
import java.util.ArrayList;
import java.util.Collection;
import org.simantics.scl.types.TCon;
import org.simantics.scl.types.TMetaVar;
import org.simantics.scl.types.TUnion;
import org.simantics.scl.types.Type;
import org.simantics.scl.types.Types;

public class EffectIdMap {
    public static final int MIN = 0;
    public static final int MAX = -1;
    private static final int FIRST_FREE_EFFECT_ID = 16;
    private static ArrayList<TCon> effectCons = new ArrayList();
    private static TObjectIntHashMap<TCon> effectCodes = new TObjectIntHashMap();
    private ArrayList<Type> localCons = new ArrayList();
    private TObjectIntHashMap<Type> localCodes = new TObjectIntHashMap();
    private int freshId = 16;

    static {
        EffectIdMap.add("Simantics/DB", "WriteGraph", 12);
        EffectIdMap.add("Simantics/DB", "ReadGraph", 4);
        EffectIdMap.add("Builtin", "Proc", 1);
    }

    private static void add(String module, String name, int code) {
        TCon con = Types.con(module, name);
        effectCodes.put((Object)con, code);
        effectCons.add(con);
    }

    public int toId(Type type, Collection<TMetaVar> metaVars) {
        if ((type = Types.canonical(type)) instanceof TUnion) {
            int id = 0;
            Type[] typeArray = ((TUnion)type).effects;
            int n = ((TUnion)type).effects.length;
            int n2 = 0;
            while (n2 < n) {
                Type e = typeArray[n2];
                id |= this.toId(e, metaVars);
                ++n2;
            }
            return id;
        }
        if (effectCodes.contains((Object)type)) {
            return effectCodes.get((Object)type);
        }
        if (type instanceof TMetaVar) {
            metaVars.add((TMetaVar)type);
            return 0;
        }
        if (this.localCodes.contains((Object)type)) {
            return this.localCodes.get((Object)type);
        }
        int id = this.freshId;
        this.localCons.add(type);
        this.localCodes.put((Object)type, id);
        this.freshId *= 2;
        return id;
    }

    public Type toType(int id) {
        int conId;
        if (id == 0) {
            return Types.NO_EFFECTS;
        }
        ArrayList<Type> components = new ArrayList<Type>();
        for (TCon tCon : effectCons) {
            conId = effectCodes.get((Object)tCon);
            if ((id & conId) != conId) continue;
            components.add(tCon);
            id ^= conId;
        }
        for (Type type : this.localCons) {
            conId = this.localCodes.get((Object)type);
            if ((id & conId) != conId) continue;
            components.add(type);
            id ^= conId;
        }
        if (components.size() == 1) {
            return components.get(0);
        }
        return Types.union(components);
    }
}

