/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.types;

import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import org.simantics.scl.compiler.common.exceptions.InternalCompilerError;
import org.simantics.scl.compiler.serialization.annotations.Create;
import org.simantics.scl.types.TCon;
import org.simantics.scl.types.TMetaVar;
import org.simantics.scl.types.TVar;
import org.simantics.scl.types.Type;
import org.simantics.scl.types.internal.TypeHashCodeContext;
import org.simantics.scl.types.internal.ast.TConAst;
import org.simantics.scl.types.internal.ast.TypeAst;
import org.simantics.scl.types.util.Polarity;
import org.simantics.scl.types.util.TypeUnparsingContext;

public class TUnion
extends Type {
    public final Type[] effects;

    @Create(value={"effects"})
    public TUnion(Type ... effects) {
        Type[] typeArray = effects;
        int n = effects.length;
        int n2 = 0;
        while (n2 < n) {
            Type effect = typeArray[n2];
            if (effect == null) {
                throw new InternalCompilerError();
            }
            ++n2;
        }
        this.effects = effects;
    }

    @Override
    public Type replace(TVar var, Type replacement) {
        int i = 0;
        while (i < this.effects.length) {
            Type effect = this.effects[i];
            Type newEffect = effect.replace(var, replacement);
            if (newEffect != effect) {
                Type[] newEffects = new Type[this.effects.length];
                int j = 0;
                while (j < i) {
                    newEffects[j] = this.effects[j];
                    ++j;
                }
                newEffects[i] = newEffect;
                j = i + 1;
                while (j < this.effects.length) {
                    newEffects[j] = this.effects[j].replace(var, replacement);
                    ++j;
                }
                return new TUnion(newEffects);
            }
            ++i;
        }
        return this;
    }

    @Override
    public TypeAst toTypeAst(TypeUnparsingContext context) {
        StringBuilder b = new StringBuilder();
        b.append("#");
        int i = 0;
        while (i < this.effects.length) {
            if (i > 0) {
                b.append(",");
            }
            b.append(this.effects[i].toString(context));
            ++i;
        }
        b.append("#");
        return new TConAst(b.toString());
    }

    @Override
    public void toName(TypeUnparsingContext context, StringBuilder b) {
        Type[] typeArray = this.effects;
        int n = this.effects.length;
        int n2 = 0;
        while (n2 < n) {
            Type effect = typeArray[n2];
            effect.toName(context, b);
            ++n2;
        }
    }

    @Override
    public void updateHashCode(TypeHashCodeContext context) {
        context.append(-1617985681);
        Type[] typeArray = this.effects;
        int n = this.effects.length;
        int n2 = 0;
        while (n2 < n) {
            Type effect = typeArray[n2];
            effect.updateHashCode(context);
            ++n2;
        }
    }

    @Override
    public void collectFreeVars(ArrayList<TVar> vars) {
        Type[] typeArray = this.effects;
        int n = this.effects.length;
        int n2 = 0;
        while (n2 < n) {
            Type effect = typeArray[n2];
            effect.collectFreeVars(vars);
            ++n2;
        }
    }

    @Override
    public void collectMetaVars(ArrayList<TMetaVar> vars) {
        Type[] typeArray = this.effects;
        int n = this.effects.length;
        int n2 = 0;
        while (n2 < n) {
            Type effect = typeArray[n2];
            effect.collectMetaVars(vars);
            ++n2;
        }
    }

    @Override
    public void collectMetaVars(THashSet<TMetaVar> vars) {
        Type[] typeArray = this.effects;
        int n = this.effects.length;
        int n2 = 0;
        while (n2 < n) {
            Type effect = typeArray[n2];
            effect.collectMetaVars(vars);
            ++n2;
        }
    }

    @Override
    public boolean isGround() {
        Type[] typeArray = this.effects;
        int n = this.effects.length;
        int n2 = 0;
        while (n2 < n) {
            Type effect = typeArray[n2];
            if (!effect.isGround()) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    @Override
    public boolean containsMetaVars() {
        Type[] typeArray = this.effects;
        int n = this.effects.length;
        int n2 = 0;
        while (n2 < n) {
            Type effect = typeArray[n2];
            if (effect.containsMetaVars()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public int getClassId() {
        return 7;
    }

    @Override
    public boolean contains(TMetaVar other) {
        Type[] typeArray = this.effects;
        int n = this.effects.length;
        int n2 = 0;
        while (n2 < n) {
            Type type = typeArray[n2];
            if (type.contains(other)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public void convertMetaVarsToVars() {
        Type[] typeArray = this.effects;
        int n = this.effects.length;
        int n2 = 0;
        while (n2 < n) {
            Type effect = typeArray[n2];
            effect.convertMetaVarsToVars();
            ++n2;
        }
    }

    @Override
    public Type removeMetaVars() {
        int i = 0;
        while (i < this.effects.length) {
            this.effects[i] = this.effects[i].removeMetaVars();
            ++i;
        }
        return this;
    }

    @Override
    public boolean isMinimal() {
        return this.effects.length == 0;
    }

    @Override
    public boolean isMaximal() {
        return false;
    }

    @Override
    public void addPolarity(Polarity polarity) {
        Type[] typeArray = this.effects;
        int n = this.effects.length;
        int n2 = 0;
        while (n2 < n) {
            Type effect = typeArray[n2];
            effect.addPolarity(polarity);
            ++n2;
        }
    }

    @Override
    public void collectEffectMetaVars(ArrayList<TMetaVar> vars) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void collectConcreteEffects(ArrayList<TCon> concreteEffects) {
        Type[] typeArray = this.effects;
        int n = this.effects.length;
        int n2 = 0;
        while (n2 < n) {
            Type effect = typeArray[n2];
            effect.collectConcreteEffects(concreteEffects);
            ++n2;
        }
    }

    @Override
    public Type head() {
        throw new UnsupportedOperationException();
    }
}

