/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.types;

import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import org.simantics.scl.compiler.serialization.annotations.ExternalCreate;
import org.simantics.scl.types.TCon;
import org.simantics.scl.types.TMetaVar;
import org.simantics.scl.types.TVar;
import org.simantics.scl.types.Type;
import org.simantics.scl.types.Types;
import org.simantics.scl.types.exceptions.KindUnificationException;
import org.simantics.scl.types.internal.TypeHashCodeContext;
import org.simantics.scl.types.internal.ast.TApplyAst;
import org.simantics.scl.types.internal.ast.TypeAst;
import org.simantics.scl.types.kinds.Kind;
import org.simantics.scl.types.kinds.KindingContext;
import org.simantics.scl.types.kinds.Kinds;
import org.simantics.scl.types.util.Polarity;
import org.simantics.scl.types.util.TypeUnparsingContext;

@ExternalCreate(factory=Types.class, method="pred", parameters={"typeClass", "parameters"})
public class TPred
extends Type {
    public static final TPred[] EMPTY_ARRAY = new TPred[0];
    public final TCon typeClass;
    public final Type[] parameters;

    TPred(TCon typeClass, Type ... parameters) {
        if (typeClass == null || parameters == null) {
            throw new NullPointerException();
        }
        Type[] typeArray = parameters;
        int n = parameters.length;
        int n2 = 0;
        while (n2 < n) {
            Type parameter = typeArray[n2];
            if (parameter == null) {
                throw new NullPointerException();
            }
            ++n2;
        }
        this.typeClass = typeClass;
        this.parameters = parameters;
    }

    @Override
    public TPred replace(TVar var, Type replacement) {
        int i = 0;
        while (i < this.parameters.length) {
            Type parameter = this.parameters[i];
            Type newParameter = parameter.replace(var, replacement);
            if (parameter != newParameter) {
                Type[] newParameters = new Type[this.parameters.length];
                int j = 0;
                while (j < i) {
                    newParameters[j] = this.parameters[j];
                    ++j;
                }
                newParameters[i] = newParameter;
                j = i + 1;
                while (j < this.parameters.length) {
                    newParameters[j] = this.parameters[j].replace(var, replacement);
                    ++j;
                }
                return new TPred(this.typeClass, newParameters);
            }
            ++i;
        }
        return this;
    }

    @Override
    public TypeAst toTypeAst(TypeUnparsingContext context) {
        TypeAst ast = this.typeClass.toTypeAst(context);
        Type[] typeArray = this.parameters;
        int n = this.parameters.length;
        int n2 = 0;
        while (n2 < n) {
            Type parameter = typeArray[n2];
            ast = new TApplyAst(ast, parameter.toTypeAst(context));
            ++n2;
        }
        return ast;
    }

    @Override
    public void updateHashCode(TypeHashCodeContext context) {
        this.typeClass.updateHashCode(context);
        Type[] typeArray = this.parameters;
        int n = this.parameters.length;
        int n2 = 0;
        while (n2 < n) {
            Type parameter = typeArray[n2];
            parameter.updateHashCode(context);
            ++n2;
        }
    }

    @Override
    public void collectFreeVars(ArrayList<TVar> vars) {
        Type[] typeArray = this.parameters;
        int n = this.parameters.length;
        int n2 = 0;
        while (n2 < n) {
            Type parameter = typeArray[n2];
            parameter.collectFreeVars(vars);
            ++n2;
        }
    }

    @Override
    public void collectMetaVars(ArrayList<TMetaVar> vars) {
        Type[] typeArray = this.parameters;
        int n = this.parameters.length;
        int n2 = 0;
        while (n2 < n) {
            Type parameter = typeArray[n2];
            parameter.collectMetaVars(vars);
            ++n2;
        }
    }

    @Override
    public void collectMetaVars(THashSet<TMetaVar> vars) {
        Type[] typeArray = this.parameters;
        int n = this.parameters.length;
        int n2 = 0;
        while (n2 < n) {
            Type parameter = typeArray[n2];
            parameter.collectMetaVars(vars);
            ++n2;
        }
    }

    @Override
    public boolean contains(TMetaVar other) {
        Type[] typeArray = this.parameters;
        int n = this.parameters.length;
        int n2 = 0;
        while (n2 < n) {
            Type parameter = typeArray[n2];
            if (parameter.contains(other)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public TPred removeMetaVars() {
        int i = 0;
        while (i < this.parameters.length) {
            Type parameter = this.parameters[i];
            Type temp = parameter.removeMetaVars();
            if (temp != parameter) {
                Type[] newParameters = new Type[this.parameters.length];
                int j = 0;
                while (j < i) {
                    newParameters[j] = this.parameters[j];
                    ++j;
                }
                newParameters[i] = temp;
                j = i + 1;
                while (j < this.parameters.length) {
                    newParameters[j] = this.parameters[j].removeMetaVars();
                    ++j;
                }
                return new TPred(this.typeClass, this.parameters);
            }
            ++i;
        }
        return this;
    }

    @Override
    public boolean isGround() {
        Type[] typeArray = this.parameters;
        int n = this.parameters.length;
        int n2 = 0;
        while (n2 < n) {
            Type parameter = typeArray[n2];
            if (!parameter.isGround()) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    @Override
    public Kind inferKind(KindingContext context) throws KindUnificationException {
        return Kinds.STAR;
    }

    @Override
    public boolean containsMetaVars() {
        Type[] typeArray = this.parameters;
        int n = this.parameters.length;
        int n2 = 0;
        while (n2 < n) {
            Type parameter = typeArray[n2];
            if (parameter.containsMetaVars()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public void toName(TypeUnparsingContext context, StringBuilder b) {
        this.typeClass.toName(context, b);
        Type[] typeArray = this.parameters;
        int n = this.parameters.length;
        int n2 = 0;
        while (n2 < n) {
            Type parameter = typeArray[n2];
            parameter.toName(context, b);
            ++n2;
        }
    }

    @Override
    public int getClassId() {
        return 4;
    }

    @Override
    public void convertMetaVarsToVars() {
        Type[] typeArray = this.parameters;
        int n = this.parameters.length;
        int n2 = 0;
        while (n2 < n) {
            Type parameter = typeArray[n2];
            parameter.convertMetaVarsToVars();
            ++n2;
        }
    }

    @Override
    public void addPolarity(Polarity polarity) {
        Type[] typeArray = this.parameters;
        int n = this.parameters.length;
        int n2 = 0;
        while (n2 < n) {
            Type parameter = typeArray[n2];
            parameter.addPolarity(Polarity.BIPOLAR);
            ++n2;
        }
    }

    @Override
    public void collectEffectMetaVars(ArrayList<TMetaVar> vars) {
        Type[] typeArray = this.parameters;
        int n = this.parameters.length;
        int n2 = 0;
        while (n2 < n) {
            Type parameter = typeArray[n2];
            parameter.collectEffectMetaVars(vars);
            ++n2;
        }
    }

    @Override
    public Type head() {
        throw new UnsupportedOperationException();
    }
}

