/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.types;

import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import org.simantics.scl.types.TCon;
import org.simantics.scl.types.TVar;
import org.simantics.scl.types.Type;
import org.simantics.scl.types.Types;
import org.simantics.scl.types.exceptions.KindUnificationException;
import org.simantics.scl.types.exceptions.UnificationException;
import org.simantics.scl.types.internal.TypeHashCodeContext;
import org.simantics.scl.types.internal.ast.TVarAst;
import org.simantics.scl.types.internal.ast.TypeAst;
import org.simantics.scl.types.kinds.KMetaVar;
import org.simantics.scl.types.kinds.Kind;
import org.simantics.scl.types.kinds.KindingContext;
import org.simantics.scl.types.kinds.Kinds;
import org.simantics.scl.types.util.Polarity;
import org.simantics.scl.types.util.TypeUnparsingContext;

public class TMetaVar
extends Type {
    public static final TMetaVar[] EMPTY_ARRAY = new TMetaVar[0];
    Type ref = null;
    Polarity polarity = Polarity.NO_POLARITY;
    private Kind kind;
    MetaVarListener listeners;

    TMetaVar(Kind kind) {
        this.kind = kind;
    }

    public Kind getKind() {
        if (this.kind instanceof KMetaVar) {
            this.kind = Kinds.canonical(this.kind);
        }
        return this.kind;
    }

    private void fireListeners() {
        MetaVarListener listener = this.listeners;
        while (listener != null) {
            listener.run();
            listener = listener.next;
        }
        this.listeners = null;
    }

    @Override
    public Type replace(TVar var, Type replacement) {
        if (this.ref == null) {
            return this;
        }
        Type newRef = this.ref.replace(var, replacement);
        if (newRef != this.ref) {
            return newRef;
        }
        return this;
    }

    @Override
    public TypeAst toTypeAst(TypeUnparsingContext context) {
        if (this.ref == null) {
            return new TVarAst(String.valueOf(this.polarity.getSymbol()) + context.getName(this));
        }
        return this.ref.toTypeAst(context);
    }

    @Override
    public int hashCode() {
        if (this.ref == null) {
            return System.identityHashCode(this);
        }
        return this.ref.hashCode();
    }

    @Override
    public void updateHashCode(TypeHashCodeContext context) {
        if (this.ref == null) {
            context.append(System.identityHashCode(this));
        } else {
            this.ref.updateHashCode(context);
        }
    }

    @Override
    public void collectFreeVars(ArrayList<TVar> vars) {
        if (this.ref != null) {
            this.ref.collectFreeVars(vars);
        }
    }

    @Override
    public void collectMetaVars(ArrayList<TMetaVar> vars) {
        if (this.ref == null) {
            vars.add(this);
        } else {
            this.ref.collectMetaVars(vars);
        }
    }

    @Override
    public void collectMetaVars(THashSet<TMetaVar> vars) {
        if (this.ref == null) {
            vars.add((Object)this);
        } else {
            this.ref.collectMetaVars(vars);
        }
    }

    @Override
    public void collectEffectMetaVars(ArrayList<TMetaVar> vars) {
        if (this.ref != null) {
            this.ref.collectEffectMetaVars(vars);
        }
    }

    public void setRef(Type a) throws UnificationException {
        if ((a = Types.weakCanonical(a)).contains(this)) {
            throw new UnificationException(this, a);
        }
        this.fireListeners();
        this.ref = a;
        if (this.polarity != Polarity.NO_POLARITY) {
            a.addPolarity(this.polarity);
        }
    }

    public Type getRef() {
        return this.ref;
    }

    @Override
    public boolean contains(TMetaVar other) {
        if (this.ref == null) {
            return this == other;
        }
        return this.ref.contains(other);
    }

    @Override
    public void convertMetaVarsToVars() {
        if (this.ref == null) {
            this.fireListeners();
            this.ref = Types.var(this.getKind());
        } else {
            this.ref.convertMetaVarsToVars();
        }
    }

    @Override
    public Type removeMetaVars() {
        if (this.ref == null) {
            return this;
        }
        return this.ref.removeMetaVars();
    }

    @Override
    public boolean isGround() {
        if (this.ref == null) {
            return false;
        }
        return this.ref.isGround();
    }

    @Override
    public Kind inferKind(KindingContext context) throws KindUnificationException {
        return Kinds.metaVar();
    }

    @Override
    public boolean containsMetaVars() {
        if (this.ref == null) {
            return true;
        }
        return this.ref.containsMetaVars();
    }

    @Override
    public void toName(TypeUnparsingContext context, StringBuilder b) {
        if (this.ref != null) {
            this.ref.toName(context, b);
        } else {
            b.append(context.getName(this));
        }
    }

    @Override
    public int getClassId() {
        return 5;
    }

    @Override
    public boolean isMaximal() {
        return this.ref != null && this.ref.isMaximal();
    }

    @Override
    public boolean isMinimal() {
        return this.ref != null && this.ref.isMinimal();
    }

    @Override
    public void addPolarity(Polarity polarity) {
        if (this.ref != null) {
            this.ref.addPolarity(polarity);
        } else {
            this.polarity = this.polarity.add(polarity);
        }
    }

    public Polarity getPolarity() {
        return this.polarity;
    }

    @Override
    public void collectConcreteEffects(ArrayList<TCon> concreteEffects) {
        if (this.ref != null) {
            this.ref.collectConcreteEffects(concreteEffects);
        }
    }

    @Override
    public Type head() {
        if (this.ref != null) {
            return this.ref.head();
        }
        return this;
    }

    public static abstract class MetaVarListener
    implements Runnable {
        private Object prev;
        private MetaVarListener next;

        public MetaVarListener(TMetaVar var) {
            this.attach(var);
        }

        public void attach(TMetaVar var) {
            this.next = var.listeners;
            if (this.next != null) {
                this.next.prev = this;
            }
            var.listeners = this;
            this.prev = var;
        }

        public void detach() {
            if (this.next != null) {
                this.next.prev = this.prev;
            }
            if (this.prev instanceof MetaVarListener) {
                ((MetaVarListener)this.prev).next = this.next;
            } else if (this.prev instanceof TMetaVar) {
                ((TMetaVar)this.prev).listeners = this.next;
            }
        }
    }
}

