/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.types;

import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import org.simantics.scl.compiler.serialization.annotations.ExternalCreate;
import org.simantics.scl.types.TMetaVar;
import org.simantics.scl.types.TPred;
import org.simantics.scl.types.TVar;
import org.simantics.scl.types.Type;
import org.simantics.scl.types.Types;
import org.simantics.scl.types.exceptions.KindUnificationException;
import org.simantics.scl.types.internal.TypeHashCodeContext;
import org.simantics.scl.types.internal.ast.TEffectAst;
import org.simantics.scl.types.internal.ast.TFunctionAst;
import org.simantics.scl.types.internal.ast.TPredAst;
import org.simantics.scl.types.internal.ast.TypeAst;
import org.simantics.scl.types.kinds.Kind;
import org.simantics.scl.types.kinds.KindingContext;
import org.simantics.scl.types.kinds.Kinds;
import org.simantics.scl.types.util.Polarity;
import org.simantics.scl.types.util.TypeUnparsingContext;

@ExternalCreate(factory=Types.class, method="functionE", parameters={"domain", "effect", "range"})
public class TFun
extends Type {
    public final Type domain;
    public final Type effect;
    public final Type range;

    TFun(Type domain, Type effect, Type range) {
        if (domain == null) {
            throw new NullPointerException();
        }
        if (effect == null) {
            throw new NullPointerException();
        }
        if (range == null) {
            throw new NullPointerException();
        }
        this.domain = domain;
        this.effect = effect;
        this.range = range;
    }

    @Override
    public Type replace(TVar var, Type replacement) {
        Type newDomain = this.domain.replace(var, replacement);
        Type newEffect = this.effect.replace(var, replacement);
        Type newRange = this.range.replace(var, replacement);
        if (newDomain == this.domain && newEffect == this.effect && newRange == this.range) {
            return this;
        }
        return new TFun(newDomain, newEffect, newRange);
    }

    @Override
    public TypeAst toTypeAst(TypeUnparsingContext context) {
        Type dom;
        TypeAst domainAst = this.domain.toTypeAst(context);
        TypeAst rangeAst = this.range.toTypeAst(context);
        if (Types.canonical(this.effect) != Types.NO_EFFECTS) {
            rangeAst = new TEffectAst(this.effect.toTypeAst(context), rangeAst);
        }
        if ((dom = Types.canonical(this.domain)) instanceof TPred) {
            return new TPredAst(domainAst, rangeAst);
        }
        if (dom == Types.PUNIT) {
            return rangeAst;
        }
        return new TFunctionAst(domainAst, rangeAst);
    }

    @Override
    public void toName(TypeUnparsingContext context, StringBuilder b) {
        this.domain.toName(context, b);
        this.effect.toName(context, b);
        this.range.toName(context, b);
    }

    @Override
    public void updateHashCode(TypeHashCodeContext context) {
        context.append(-14073069);
        this.domain.updateHashCode(context);
        this.effect.updateHashCode(context);
        this.range.updateHashCode(context);
    }

    @Override
    public void collectFreeVars(ArrayList<TVar> vars) {
        this.domain.collectFreeVars(vars);
        this.effect.collectFreeVars(vars);
        this.range.collectFreeVars(vars);
    }

    @Override
    public void collectMetaVars(ArrayList<TMetaVar> vars) {
        this.domain.collectMetaVars(vars);
        this.effect.collectMetaVars(vars);
        this.range.collectMetaVars(vars);
    }

    @Override
    public void collectMetaVars(THashSet<TMetaVar> vars) {
        this.domain.collectMetaVars(vars);
        this.effect.collectMetaVars(vars);
        this.range.collectMetaVars(vars);
    }

    @Override
    public void collectEffectMetaVars(ArrayList<TMetaVar> vars) {
        this.domain.collectEffectMetaVars(vars);
        this.effect.collectMetaVars(vars);
        this.range.collectEffectMetaVars(vars);
    }

    @Override
    public boolean isGround() {
        return this.domain.isGround() && this.effect.isGround() && this.range.isGround();
    }

    @Override
    public boolean containsMetaVars() {
        return this.domain.containsMetaVars() || this.effect.containsMetaVars() || this.range.containsMetaVars();
    }

    @Override
    public boolean contains(TMetaVar other) {
        return this.domain.contains(other) || this.effect.contains(other) || this.range.contains(other);
    }

    @Override
    public int getClassId() {
        return 0;
    }

    @Override
    public Kind inferKind(KindingContext context) throws KindUnificationException {
        this.domain.checkKind(context, Kinds.STAR);
        this.range.checkKind(context, Kinds.STAR);
        return Kinds.STAR;
    }

    @Override
    public void convertMetaVarsToVars() {
        this.domain.convertMetaVarsToVars();
        this.effect.convertMetaVarsToVars();
        this.range.convertMetaVarsToVars();
    }

    @Override
    public Type removeMetaVars() {
        Type newDomain = this.domain.removeMetaVars();
        Type newEffect = this.effect.removeMetaVars();
        Type newRange = this.range.removeMetaVars();
        if (newDomain == this.domain && newEffect == this.effect && newRange == this.range) {
            return this;
        }
        return new TFun(newDomain, newEffect, newRange);
    }

    @Override
    public boolean isMinimal() {
        return Types.canonical(this.effect) == Types.NO_EFFECTS && this.range.isMinimal() && this.domain.isMaximal();
    }

    @Override
    public boolean isMaximal() {
        return false;
    }

    @Override
    public void addPolarity(Polarity polarity) {
        this.domain.addPolarity(polarity.flip());
        this.effect.addPolarity(polarity);
        this.range.addPolarity(polarity);
    }

    @Override
    public Type head() {
        return Types.ARROW;
    }
}

