/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.types;

import gnu.trove.map.hash.TObjectIntHashMap;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import org.simantics.scl.compiler.serialization.annotations.ExternalCreate;
import org.simantics.scl.types.TMetaVar;
import org.simantics.scl.types.TVar;
import org.simantics.scl.types.Type;
import org.simantics.scl.types.Types;
import org.simantics.scl.types.exceptions.KindUnificationException;
import org.simantics.scl.types.internal.TypeHashCodeContext;
import org.simantics.scl.types.internal.ast.TForAllAst;
import org.simantics.scl.types.internal.ast.TypeAst;
import org.simantics.scl.types.kinds.Kind;
import org.simantics.scl.types.kinds.KindingContext;
import org.simantics.scl.types.kinds.Kinds;
import org.simantics.scl.types.util.Polarity;
import org.simantics.scl.types.util.TypeUnparsingContext;

@ExternalCreate(factory=Types.class, method="forAll", parameters={"var", "type"})
public class TForAll
extends Type {
    public final TVar var;
    public final Type type;

    TForAll(TVar var, Type type) {
        if (var == null || type == null) {
            throw new NullPointerException();
        }
        this.var = var;
        this.type = type;
    }

    private TForAll create(Type type) {
        if (type == this.type) {
            return this;
        }
        return new TForAll(this.var, type);
    }

    @Override
    public TForAll replace(TVar var, Type replacement) {
        if (var == this.var) {
            throw new IllegalStateException("Tried to replace a variable that is not free in the type.");
        }
        return this.create(this.type.replace(var, replacement));
    }

    @Override
    public TypeAst toTypeAst(TypeUnparsingContext context) {
        ArrayList<String> vars = new ArrayList<String>();
        vars.add(context.getName(this.var));
        Type cur = Types.canonical(this.type);
        while (cur instanceof TForAll) {
            TForAll forAll = (TForAll)cur;
            vars.add(context.getName(forAll.var));
            cur = Types.canonical(forAll.type);
        }
        return new TForAllAst(vars.toArray(new String[vars.size()]), cur.toTypeAst(context));
    }

    @Override
    public void updateHashCode(TypeHashCodeContext context) {
        context.append(-231468493);
        TObjectIntHashMap<TVar> varHashCode = context.createVarHashCode();
        varHashCode.put((Object)this.var, varHashCode.size());
        this.type.updateHashCode(context);
        varHashCode.remove((Object)this.var);
    }

    @Override
    public void collectFreeVars(ArrayList<TVar> vars) {
        this.type.collectFreeVars(vars);
        vars.remove(this.var);
    }

    @Override
    public void collectMetaVars(ArrayList<TMetaVar> vars) {
        this.type.collectMetaVars(vars);
    }

    @Override
    public void collectMetaVars(THashSet<TMetaVar> vars) {
        this.type.collectMetaVars(vars);
    }

    @Override
    public void collectEffectMetaVars(ArrayList<TMetaVar> vars) {
        this.type.collectEffectMetaVars(vars);
    }

    @Override
    public boolean contains(TMetaVar other) {
        return this.type.contains(other);
    }

    @Override
    public void convertMetaVarsToVars() {
        this.type.convertMetaVarsToVars();
    }

    @Override
    public TForAll removeMetaVars() {
        Type newType = this.type.removeMetaVars();
        if (newType == this.type) {
            return this;
        }
        return new TForAll(this.var, this.type);
    }

    @Override
    public boolean isGround() {
        return false;
    }

    @Override
    public Kind inferKind(KindingContext context) throws KindUnificationException {
        this.type.checkKind(context, Kinds.STAR);
        return Kinds.STAR;
    }

    @Override
    public boolean containsMetaVars() {
        return this.type.containsMetaVars();
    }

    @Override
    public void toName(TypeUnparsingContext context, StringBuilder b) {
        this.type.toName(context, b);
    }

    @Override
    public int getClassId() {
        return 3;
    }

    @Override
    public void addPolarity(Polarity polarity) {
        this.type.addPolarity(polarity);
    }

    @Override
    public Type head() {
        return this;
    }
}

