/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.types;

import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import org.simantics.scl.compiler.serialization.annotations.ExternalCreate;
import org.simantics.scl.types.TMetaVar;
import org.simantics.scl.types.TVar;
import org.simantics.scl.types.Type;
import org.simantics.scl.types.Types;
import org.simantics.scl.types.exceptions.KindUnificationException;
import org.simantics.scl.types.internal.TypeHashCodeContext;
import org.simantics.scl.types.internal.ast.TConAst;
import org.simantics.scl.types.internal.ast.TypeAst;
import org.simantics.scl.types.kinds.Kind;
import org.simantics.scl.types.kinds.KindingContext;
import org.simantics.scl.types.util.Polarity;
import org.simantics.scl.types.util.TypeUnparsingContext;

@ExternalCreate(factory=Types.class, method="con", parameters={"module", "name"})
public class TCon
extends Type {
    public final String module;
    public final String name;

    TCon(String module, String name) {
        if (module == null || name == null) {
            throw new NullPointerException();
        }
        this.module = module;
        this.name = name;
    }

    @Override
    public TCon replace(TVar var, Type replacement) {
        return this;
    }

    @Override
    public TypeAst toTypeAst(TypeUnparsingContext context) {
        if (this.module == "Builtin") {
            char c = this.name.charAt(0);
            if (Character.isLetter(c) || c == '(' || this.name.equals("[]")) {
                return new TConAst(this.name);
            }
            return new TConAst("(" + this.name + ")");
        }
        return new TConAst(this.name.length() <= 1 ? String.valueOf(TCon.simplifiedModuleName(this.module)) + "." + this.name : this.name);
    }

    private static String simplifiedModuleName(String name) {
        int p = name.lastIndexOf(47);
        if (p == -1) {
            return name;
        }
        return name.substring(p + 1);
    }

    @Override
    public boolean equals(Object obj) {
        while (obj instanceof TMetaVar) {
            TMetaVar metaVar = (TMetaVar)obj;
            if (metaVar.ref == null) {
                return false;
            }
            obj = metaVar.ref;
        }
        return this == obj;
    }

    @Override
    public int hashCode() {
        return System.identityHashCode(this);
    }

    @Override
    public void updateHashCode(TypeHashCodeContext context) {
        context.append(System.identityHashCode(this));
    }

    @Override
    public void collectFreeVars(ArrayList<TVar> vars) {
    }

    @Override
    public void collectMetaVars(ArrayList<TMetaVar> vars) {
    }

    @Override
    public void collectMetaVars(THashSet<TMetaVar> vars) {
    }

    @Override
    public void collectEffectMetaVars(ArrayList<TMetaVar> vars) {
    }

    @Override
    public boolean isGround() {
        return true;
    }

    @Override
    public Kind inferKind(KindingContext context) throws KindUnificationException {
        Kind kind = context.getKind(this);
        if (kind == null) {
            throw new KindUnificationException();
        }
        return kind;
    }

    @Override
    public boolean containsMetaVars() {
        return false;
    }

    @Override
    public void toName(TypeUnparsingContext context, StringBuilder b) {
        b.append(this.name);
    }

    @Override
    public int getClassId() {
        return 2;
    }

    @Override
    public boolean contains(TMetaVar other) {
        return false;
    }

    @Override
    public void convertMetaVarsToVars() {
    }

    @Override
    public Type removeMetaVars() {
        return this;
    }

    @Override
    public void addPolarity(Polarity polarity) {
    }

    @Override
    public void collectConcreteEffects(ArrayList<TCon> concreteEffects) {
        concreteEffects.add(this);
    }

    @Override
    public Type head() {
        return this;
    }
}

