/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.types;

import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.List;
import org.simantics.scl.compiler.serialization.annotations.ExternalCreate;
import org.simantics.scl.types.TCon;
import org.simantics.scl.types.TMetaVar;
import org.simantics.scl.types.TVar;
import org.simantics.scl.types.Type;
import org.simantics.scl.types.Types;
import org.simantics.scl.types.exceptions.KindUnificationException;
import org.simantics.scl.types.internal.TypeHashCodeContext;
import org.simantics.scl.types.internal.ast.TApplyAst;
import org.simantics.scl.types.internal.ast.TListAst;
import org.simantics.scl.types.internal.ast.TTupleAst;
import org.simantics.scl.types.internal.ast.TypeAst;
import org.simantics.scl.types.kinds.Kind;
import org.simantics.scl.types.kinds.KindingContext;
import org.simantics.scl.types.kinds.Kinds;
import org.simantics.scl.types.util.Polarity;
import org.simantics.scl.types.util.TMultiApply;
import org.simantics.scl.types.util.TypeUnparsingContext;

@ExternalCreate(factory=Types.class, method="apply", parameters={"function", "parameter"})
public class TApply
extends Type {
    public final Type function;
    public final Type parameter;

    public TApply(Type function, Type parameter) {
        if (function == null) {
            throw new NullPointerException();
        }
        if (parameter == null) {
            throw new NullPointerException();
        }
        this.function = function;
        this.parameter = parameter;
    }

    private TApply create(Type function, Type parameter) {
        if (function == this.function && parameter == this.parameter) {
            return this;
        }
        return new TApply(function, parameter);
    }

    @Override
    public TApply replace(TVar var, Type replacement) {
        return this.create(this.function.replace(var, replacement), this.parameter.replace(var, replacement));
    }

    @Override
    public TypeAst toTypeAst(TypeUnparsingContext context) {
        TMultiApply multiApply = Types.toMultiApply(this);
        Type function = multiApply.function;
        List<Type> parameters = multiApply.parameters;
        TypeAst ast = null;
        int parameterPos = 0;
        if (function instanceof TCon) {
            if (function == Types.LIST && parameters.size() >= 1) {
                ast = new TListAst(parameters.get(0).toTypeAst(context));
                parameterPos = 1;
            } else {
                TCon con = (TCon)function;
                if (con.module == "Builtin" && con.name.charAt(0) == '(') {
                    int tupleLength = con.name.length() - 2;
                    if (tupleLength > 0) {
                        ++tupleLength;
                    }
                    if (parameters.size() >= tupleLength) {
                        TypeAst[] components = new TypeAst[tupleLength];
                        int i = 0;
                        while (i < tupleLength) {
                            components[i] = parameters.get(i).toTypeAst(context);
                            ++i;
                        }
                        ast = new TTupleAst(components);
                        parameterPos = tupleLength;
                    }
                }
            }
        }
        if (ast == null) {
            ast = function.toTypeAst(context);
        }
        while (parameterPos < multiApply.parameters.size()) {
            ast = new TApplyAst(ast, parameters.get(parameterPos).toTypeAst(context));
            ++parameterPos;
        }
        return ast;
    }

    @Override
    public void updateHashCode(TypeHashCodeContext context) {
        context.append(305419896);
        this.function.updateHashCode(context);
        this.parameter.updateHashCode(context);
    }

    @Override
    public void collectFreeVars(ArrayList<TVar> vars) {
        this.function.collectFreeVars(vars);
        this.parameter.collectFreeVars(vars);
    }

    @Override
    public void collectMetaVars(ArrayList<TMetaVar> vars) {
        this.function.collectMetaVars(vars);
        this.parameter.collectMetaVars(vars);
    }

    @Override
    public void collectMetaVars(THashSet<TMetaVar> vars) {
        this.function.collectMetaVars(vars);
        this.parameter.collectMetaVars(vars);
    }

    @Override
    public void collectEffectMetaVars(ArrayList<TMetaVar> vars) {
        this.function.collectEffectMetaVars(vars);
        this.parameter.collectEffectMetaVars(vars);
    }

    @Override
    public boolean contains(TMetaVar other) {
        return this.function.contains(other) || this.parameter.contains(other);
    }

    @Override
    public void convertMetaVarsToVars() {
        this.function.convertMetaVarsToVars();
        this.parameter.convertMetaVarsToVars();
    }

    @Override
    public TApply removeMetaVars() {
        Type newFunction = this.function.removeMetaVars();
        Type newParameter = this.parameter.removeMetaVars();
        if (newFunction == this.function && newParameter == this.parameter) {
            return this;
        }
        return new TApply(newFunction, newParameter);
    }

    @Override
    public boolean isGround() {
        return this.function.isGround() && this.parameter.isGround();
    }

    @Override
    public void checkKind(KindingContext context, Kind requiredKind) throws KindUnificationException {
        Kind functionKind = this.function.inferKind(context);
        Kind parameterKind = this.parameter.inferKind(context);
        Kinds.unify(functionKind, Kinds.arrow(parameterKind, requiredKind));
    }

    @Override
    public boolean containsMetaVars() {
        return this.function.containsMetaVars() || this.parameter.containsMetaVars();
    }

    @Override
    public void toName(TypeUnparsingContext context, StringBuilder b) {
        this.function.toName(context, b);
        this.parameter.toName(context, b);
    }

    @Override
    public int getClassId() {
        return 1;
    }

    @Override
    public void addPolarity(Polarity polarity) {
        this.function.addPolarity(Polarity.BIPOLAR);
        this.parameter.addPolarity(Polarity.BIPOLAR);
    }

    @Override
    public Type head() {
        return this.function.head();
    }
}

