/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.types;

import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import org.simantics.scl.compiler.serialization.annotations.ExternalCreate;
import org.simantics.scl.types.TCon;
import org.simantics.scl.types.TMetaVar;
import org.simantics.scl.types.TVar;
import org.simantics.scl.types.Type;
import org.simantics.scl.types.Types;
import org.simantics.scl.types.internal.TypeHashCodeContext;
import org.simantics.scl.types.internal.ast.TApplyAst;
import org.simantics.scl.types.internal.ast.TypeAst;
import org.simantics.scl.types.util.Polarity;
import org.simantics.scl.types.util.TypeUnparsingContext;

@ExternalCreate(factory=Types.class, method="alias", parameters={"name", "parameters"})
public class TAlias
extends Type {
    private Type ref;
    public final TCon name;
    public final Type[] parameters;

    TAlias(TCon name, Type[] parameters) {
        this.name = name;
        this.parameters = parameters;
    }

    TAlias(Type ref, TCon name, Type[] parameters) {
        this.name = name;
        this.parameters = parameters;
        this.ref = ref;
    }

    public void setRef(Type ref) {
        this.ref = ref;
    }

    public Type getRef() {
        return this.ref;
    }

    @Override
    public Type replace(TVar var, Type replacement) {
        Type newRef = this.ref.replace(var, replacement);
        if (this.ref == newRef) {
            return this;
        }
        Type[] newParameters = new Type[this.parameters.length];
        int i = 0;
        while (i < this.parameters.length) {
            newParameters[i] = this.parameters[i].replace(var, replacement);
            ++i;
        }
        return new TAlias(this.ref, this.name, this.parameters);
    }

    @Override
    TypeAst toTypeAst(TypeUnparsingContext context) {
        TypeAst result = this.name.toTypeAst(context);
        Type[] typeArray = this.parameters;
        int n = this.parameters.length;
        int n2 = 0;
        while (n2 < n) {
            Type parameter = typeArray[n2];
            result = new TApplyAst(result, parameter.toTypeAst(context));
            ++n2;
        }
        return result;
    }

    @Override
    public void toName(TypeUnparsingContext context, StringBuilder b) {
        this.ref.toName(context, b);
    }

    @Override
    public void updateHashCode(TypeHashCodeContext context) {
        this.ref.updateHashCode(context);
    }

    @Override
    public void collectFreeVars(ArrayList<TVar> vars) {
        this.ref.collectFreeVars(vars);
    }

    @Override
    public void collectMetaVars(ArrayList<TMetaVar> vars) {
        this.ref.collectMetaVars(vars);
    }

    @Override
    public void collectMetaVars(THashSet<TMetaVar> vars) {
        this.ref.collectMetaVars(vars);
    }

    @Override
    public void collectEffectMetaVars(ArrayList<TMetaVar> vars) {
        this.ref.collectEffectMetaVars(vars);
    }

    @Override
    public boolean contains(TMetaVar other) {
        return this.ref.contains(other);
    }

    @Override
    public void convertMetaVarsToVars() {
        this.ref.convertMetaVarsToVars();
    }

    @Override
    public Type removeMetaVars() {
        Type newRef = this.ref.removeMetaVars();
        if (this.ref == newRef) {
            return this;
        }
        Type[] newParameters = new Type[this.parameters.length];
        int i = 0;
        while (i < this.parameters.length) {
            newParameters[i] = this.parameters[i].removeMetaVars();
            ++i;
        }
        return new TAlias(this.ref, this.name, this.parameters);
    }

    @Override
    public boolean isGround() {
        return this.ref.isGround();
    }

    @Override
    public boolean containsMetaVars() {
        return this.ref.containsMetaVars();
    }

    @Override
    public int getClassId() {
        return 8;
    }

    @Override
    public void addPolarity(Polarity polarity) {
        this.ref.addPolarity(polarity);
    }

    @Override
    public Type head() {
        return this.ref.head();
    }
}

